/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricCounter;
import org.apache.hadoop.metrics2.MetricGauge;
import org.apache.hadoop.metrics2.MetricsVisitor;
import org.apache.hadoop.metrics2.impl.MetricCounterInt;
import org.apache.hadoop.metrics2.impl.MetricCounterLong;
import org.apache.hadoop.metrics2.impl.MetricGaugeDouble;
import org.apache.hadoop.metrics2.impl.MetricGaugeFloat;
import org.apache.hadoop.metrics2.impl.MetricGaugeInt;
import org.apache.hadoop.metrics2.impl.MetricGaugeLong;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMetricsVisitor {
    @Captor
    private ArgumentCaptor<MetricCounter<Integer>> c1;
    @Captor
    private ArgumentCaptor<MetricCounter<Long>> c2;
    @Captor
    private ArgumentCaptor<MetricGauge<Integer>> g1;
    @Captor
    private ArgumentCaptor<MetricGauge<Long>> g2;
    @Captor
    private ArgumentCaptor<MetricGauge<Float>> g3;
    @Captor
    private ArgumentCaptor<MetricGauge<Double>> g4;

    @Test
    public void testCommon() {
        MetricsVisitor visitor = (MetricsVisitor)Mockito.mock(MetricsVisitor.class);
        List<Metric> metrics = Arrays.asList(new MetricCounterInt("c1", "int counter", 1), new MetricCounterLong("c2", "long counter", 2L), new MetricGaugeInt("g1", "int gauge", 5), new MetricGaugeLong("g2", "long gauge", 6L), new MetricGaugeFloat("g3", "float gauge", 7.0f), new MetricGaugeDouble("g4", "double gauge", 8.0));
        for (Metric metric : metrics) {
            metric.visit(visitor);
        }
        ((MetricsVisitor)Mockito.verify((Object)visitor)).counter((MetricCounter)this.c1.capture(), Mockito.eq((int)1));
        Assert.assertEquals((String)"c1 name", (Object)"c1", (Object)((MetricCounter)this.c1.getValue()).name());
        Assert.assertEquals((String)"c1 description", (Object)"int counter", (Object)((MetricCounter)this.c1.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).counter((MetricCounter)this.c2.capture(), Mockito.eq((long)2L));
        Assert.assertEquals((String)"c2 name", (Object)"c2", (Object)((MetricCounter)this.c2.getValue()).name());
        Assert.assertEquals((String)"c2 description", (Object)"long counter", (Object)((MetricCounter)this.c2.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricGauge)this.g1.capture(), Mockito.eq((int)5));
        Assert.assertEquals((String)"g1 name", (Object)"g1", (Object)((MetricGauge)this.g1.getValue()).name());
        Assert.assertEquals((String)"g1 description", (Object)"int gauge", (Object)((MetricGauge)this.g1.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricGauge)this.g2.capture(), Mockito.eq((long)6L));
        Assert.assertEquals((String)"g2 name", (Object)"g2", (Object)((MetricGauge)this.g2.getValue()).name());
        Assert.assertEquals((String)"g2 description", (Object)"long gauge", (Object)((MetricGauge)this.g2.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricGauge)this.g3.capture(), Mockito.eq((float)7.0f));
        Assert.assertEquals((String)"g3 name", (Object)"g3", (Object)((MetricGauge)this.g3.getValue()).name());
        Assert.assertEquals((String)"g3 description", (Object)"float gauge", (Object)((MetricGauge)this.g3.getValue()).description());
        ((MetricsVisitor)Mockito.verify((Object)visitor)).gauge((MetricGauge)this.g4.capture(), Mockito.eq((double)8.0));
        Assert.assertEquals((String)"g4 name", (Object)"g4", (Object)((MetricGauge)this.g4.getValue()).name());
        Assert.assertEquals((String)"g4 description", (Object)"double gauge", (Object)((MetricGauge)this.g4.getValue()).description());
    }
}

