/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.TestHttpServer;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.DefaultJobHistoryParser;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobHistoryServer;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogServlet;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TestJobHistory;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Test;

public class TestWebUIAuthorization
extends ClusterMapReduceTestCase {
    private static final Log LOG = LogFactory.getLog(TestWebUIAuthorization.class);
    private static final String jobSubmitter = "user1";
    private static final String jobSubmitter1 = "user11";
    private static final String jobSubmitter2 = "user12";
    private static final String jobSubmitter3 = "user13";
    private static String mrOwner = null;
    private static final String qAdmin = "user3";
    private static final String mrAdminUser = "user4";
    private static final String mrAdminGroup = "admingroup";
    private static final String mrAdminGroupMember = "user2";
    private static final String viewColleague = "colleague1";
    private static final String modifyColleague = "colleague2";
    private static final String viewAndModifyColleague = "colleague3";
    private static final String unauthorizedUser = "evilJohn";

    @Override
    protected void setUp() throws Exception {
    }

    static int getHttpStatusCode(String urlstring, String userName, String method) throws IOException {
        LOG.info((Object)("Accessing " + urlstring + " as user " + userName));
        URL url = new URL(urlstring + "&user.name=" + userName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        if (method.equals("POST")) {
            String encodedData = "action=kill&user.name=" + userName;
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", Integer.toString(encodedData.length()));
            connection.setDoOutput(true);
            OutputStream os = connection.getOutputStream();
            os.write(encodedData.getBytes());
        }
        connection.connect();
        return connection.getResponseCode();
    }

    private void validateViewJob(String url, String method) throws IOException {
        TestWebUIAuthorization.assertEquals((String)"Incorrect return code for job submitter user1", (int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, jobSubmitter, method));
        TestWebUIAuthorization.assertEquals((String)"Incorrect return code for admin user user4", (int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, mrAdminUser, method));
        TestWebUIAuthorization.assertEquals((String)"Incorrect return code for admingroup-member user2", (int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, mrAdminGroupMember, method));
        TestWebUIAuthorization.assertEquals((String)("Incorrect return code for MR-owner " + mrOwner), (int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, mrOwner, method));
        TestWebUIAuthorization.assertEquals((String)"Incorrect return code for queue admin user3", (int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, qAdmin, method));
        TestWebUIAuthorization.assertEquals((String)"Incorrect return code for user in job-view-acl colleague1", (int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, viewColleague, method));
        TestWebUIAuthorization.assertEquals((String)"Incorrect return code for user in job-view-acl and job-modify-acl colleague3", (int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, viewAndModifyColleague, method));
        TestWebUIAuthorization.assertEquals((String)"Incorrect return code for user in job-modify-acl colleague2", (int)401, (int)TestWebUIAuthorization.getHttpStatusCode(url, modifyColleague, method));
        TestWebUIAuthorization.assertEquals((String)"Incorrect return code for unauthorizedUser evilJohn", (int)401, (int)TestWebUIAuthorization.getHttpStatusCode(url, unauthorizedUser, method));
    }

    private void validateModifyJob(String url, String method) throws IOException {
        TestWebUIAuthorization.assertEquals((int)401, (int)TestWebUIAuthorization.getHttpStatusCode(url, viewColleague, method));
        TestWebUIAuthorization.assertEquals((int)401, (int)TestWebUIAuthorization.getHttpStatusCode(url, unauthorizedUser, method));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, modifyColleague, method));
    }

    private RunningJob startSleepJobAsUser(String user, final JobConf conf, MiniMRCluster cluster) throws Exception {
        SleepJob sleepJob = new SleepJob();
        sleepJob.setConf((Configuration)conf);
        UserGroupInformation jobSubmitterUGI = UserGroupInformation.createRemoteUser((String)user);
        RunningJob job = (RunningJob)jobSubmitterUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RunningJob>(){

            @Override
            public RunningJob run() throws Exception {
                JobClient jobClient = new JobClient(conf);
                SleepJob sleepJob = new SleepJob();
                sleepJob.setConf((Configuration)conf);
                JobConf jobConf = sleepJob.setupJobConf(1, 0, 900000L, 1, 1000L, 1000);
                RunningJob runningJob = jobClient.submitJob(jobConf);
                return runningJob;
            }
        });
        JobID jobId = job.getID();
        this.getTIPId(cluster, (org.apache.hadoop.mapreduce.JobID)jobId);
        return job;
    }

    private TaskID getTIPId(MiniMRCluster cluster, org.apache.hadoop.mapreduce.JobID jobid) throws Exception {
        JobClient client = new JobClient(cluster.createJobConf());
        JobID jobId = (JobID)jobid;
        TaskReport[] mapReports = null;
        TaskID tipId = null;
        do {
            Thread.sleep(200L);
        } while ((mapReports = client.getMapTaskReports(jobId)).length == 0);
        int i$ = 0;
        TaskReport[] arr$ = mapReports;
        int len$ = arr$.length;
        if (i$ < len$) {
            TaskReport r = arr$[i$];
            tipId = r.getTaskID();
        }
        JobTracker jt = cluster.getJobTrackerRunner().getJobTracker();
        while (jt.getTaskStatuses(tipId).length == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted while waiting for map attempt to be started");
            }
        }
        return tipId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmJobDetailsJSPKillJobAsUser(MiniMRCluster cluster, JobConf conf, String jtURL, String jobTrackerJSP, String user) throws Exception {
        RunningJob job = this.startSleepJobAsUser(jobSubmitter, conf, cluster);
        JobID jobid = job.getID();
        String url = jtURL + "/jobdetails.jsp?" + "action=kill&jobid=" + jobid.toString();
        try {
            TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, user, "POST"));
            this.waitForKillJobToFinish(job);
            TestWebUIAuthorization.assertTrue((String)"killJob failed for a job for which user has job-modify permission", (boolean)job.isComplete());
        }
        finally {
            if (!job.isComplete()) {
                LOG.info((Object)("Killing job " + jobid + " from finally block"));
                TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP + "&killJobs=true&jobCheckBox=" + jobid.toString(), jobSubmitter, "GET"));
            }
        }
    }

    static void setupGroupsProvider() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", MyGroupsProvider.class.getName());
        Groups.getUserToGroupsMappingService((Configuration)conf);
        MyGroupsProvider.mapping.put(jobSubmitter, Arrays.asList("group1"));
        MyGroupsProvider.mapping.put(viewColleague, Arrays.asList("group2"));
        MyGroupsProvider.mapping.put(modifyColleague, Arrays.asList("group1"));
        MyGroupsProvider.mapping.put(unauthorizedUser, Arrays.asList("evilSociety"));
        MyGroupsProvider.mapping.put(mrAdminGroupMember, Arrays.asList(mrAdminGroup));
        MyGroupsProvider.mapping.put(viewAndModifyColleague, Arrays.asList("group3"));
        MyGroupsProvider.mapping.put(qAdmin, Arrays.asList("group4"));
        mrOwner = UserGroupInformation.getCurrentUser().getShortUserName();
        MyGroupsProvider.mapping.put(mrOwner, Arrays.asList("group5", "group6"));
        MyGroupsProvider.mapping.put(jobSubmitter1, Arrays.asList("group7"));
        MyGroupsProvider.mapping.put(jobSubmitter2, Arrays.asList("group7"));
        MyGroupsProvider.mapping.put(jobSubmitter3, Arrays.asList("group7"));
        MyGroupsProvider.mapping.put(mrAdminUser, Arrays.asList("group8"));
    }

    public void testAuthorizationForJobHistoryPages() throws Exception {
        this.checkAuthorizationForJobHistoryPages(new Properties());
    }

    public void testAuthorizationForJobHistoryPagesStandalone() throws Exception {
        Properties props = new Properties();
        props.setProperty("mapreduce.history.server.http.address", "localhost:8090");
        props.setProperty("mapreduce.history.server.embedded", "false");
        this.checkAuthorizationForJobHistoryPages(props);
    }

    private void checkAuthorizationForJobHistoryPages(Properties props) throws Exception {
        String jobHistoryUrl;
        TestWebUIAuthorization.setupGroupsProvider();
        props.setProperty("hadoop.http.filter.initializers", TestHttpServer.DummyFilterInitializer.class.getName());
        props.setProperty("mapred.acls.enabled", String.valueOf(true));
        props.setProperty(QueueManager.toFullPropertyName((String)"default", (String)QueueManager.QueueACL.ADMINISTER_JOBS.getAclName()), qAdmin);
        props.setProperty(QueueManager.toFullPropertyName((String)"default", (String)QueueManager.QueueACL.SUBMIT_JOB.getAclName()), jobSubmitter);
        props.setProperty("dfs.permissions", "false");
        props.setProperty("mapred.job.tracker.history.completed.location", "historyDoneFolderOnHDFS");
        props.setProperty("mapreduce.cluster.administrators", "user4 admingroup");
        this.startCluster(true, props);
        MiniMRCluster cluster = this.getMRCluster();
        int infoPort = cluster.getJobTrackerRunner().getJobTrackerInfoPort();
        JobConf conf = new JobConf((Configuration)cluster.createJobConf());
        conf.set("mapreduce.job.acl-view-job", "colleague1 group3");
        JobTracker jobTracker = this.getMRCluster().getJobTrackerRunner().getJobTracker();
        String jhUrlPrefix = JobHistoryServer.getHistoryUrlPrefix((JobConf)jobTracker.conf);
        if ("false".equals(props.getProperty("mapreduce.history.server.embedded", "true"))) {
            JobHistoryServer historyServer = new JobHistoryServer(cluster.getJobTrackerRunner().getJobTracker().conf);
            historyServer.start();
            jobHistoryUrl = jhUrlPrefix;
        } else {
            jobHistoryUrl = "http://" + JobHistoryServer.getAddress((JobConf)jobTracker.conf) + jhUrlPrefix;
        }
        conf.set("mapreduce.job.acl-modify-job", " group1,group3");
        SleepJob sleepJob = new SleepJob();
        final JobConf jobConf = new JobConf((Configuration)conf);
        sleepJob.setConf((Configuration)jobConf);
        UserGroupInformation jobSubmitterUGI = UserGroupInformation.createRemoteUser((String)jobSubmitter);
        RunningJob job = (RunningJob)jobSubmitterUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RunningJob>(){

            @Override
            public RunningJob run() throws Exception {
                JobClient jobClient = new JobClient(jobConf);
                SleepJob sleepJob = new SleepJob();
                sleepJob.setConf((Configuration)jobConf);
                JobConf jobConf2 = sleepJob.setupJobConf(1, 0, 1000L, 1, 1000L, 1000);
                RunningJob runningJob = JobClient.runJob((JobConf)jobConf2);
                return runningJob;
            }
        });
        JobID jobid = job.getID();
        JobInProgress jip = jobTracker.getJob(jobid);
        JobConf finalJobConf = jip.getJobConf();
        Path doneDir = JobHistory.getCompletedJobHistoryLocation();
        while (TestJobHistory.getDoneFile(finalJobConf, jobid, doneDir) == null) {
            Thread.sleep(2000L);
        }
        Path historyFilePath = new Path(doneDir, JobHistory.JobInfo.getDoneJobHistoryFileName((JobConf)finalJobConf, (JobID)jobid));
        String urlEncodedHistoryFileName = URLEncoder.encode(historyFilePath.toString());
        String jobDetailsJSP = jobHistoryUrl + "/jobdetailshistory.jsp?logFile=" + urlEncodedHistoryFileName;
        this.validateViewJob(jobDetailsJSP, "GET");
        String jobTasksJSP = jobHistoryUrl + "/jobtaskshistory.jsp?logFile=" + urlEncodedHistoryFileName;
        String[] taskTypes = new String[]{"JOb_SETUP", "MAP", "REDUCE", "JOB_CLEANUP"};
        String[] states = new String[]{"all", "SUCCEEDED", "FAILED", "KILLED"};
        for (String taskType : taskTypes) {
            for (String state : states) {
                this.validateViewJob(jobTasksJSP + "&taskType=" + taskType + "&status=" + state, "GET");
            }
        }
        JobHistory.JobInfo jobInfo = new JobHistory.JobInfo(jobid.toString());
        DefaultJobHistoryParser.JobTasksParseListener l = new DefaultJobHistoryParser.JobTasksParseListener(jobInfo);
        JobHistory.parseHistoryFromFS((String)historyFilePath.toString().substring(5), (JobHistory.Listener)l, (FileSystem)historyFilePath.getFileSystem((Configuration)conf));
        Map tipsMap = jobInfo.getAllTasks();
        for (String tip : tipsMap.keySet()) {
            this.validateViewJob(jobHistoryUrl + "/taskdetailshistory.jsp?logFile=" + urlEncodedHistoryFileName + "&tipid=" + tip.toString(), "GET");
            Map attemptsMap = ((JobHistory.Task)tipsMap.get(tip)).getTaskAttempts();
            for (String attempt : attemptsMap.keySet()) {
                this.validateViewJob(jobHistoryUrl + "/taskstatshistory.jsp?attemptid=" + attempt.toString() + "&logFile=" + urlEncodedHistoryFileName, "GET");
                String taskLogURL = TaskLogServlet.getTaskLogUrl((String)"localhost", (String)((JobHistory.TaskAttempt)attemptsMap.get(attempt)).get(JobHistory.Keys.HTTP_PORT), (String)attempt.toString());
                this.validateViewJob(taskLogURL, "GET");
            }
        }
        Path jobACLsFilePath = new Path(TaskLog.getJobDir((org.apache.hadoop.mapreduce.JobID)jobid).toString(), TaskTracker.jobACLsFile);
        new File(jobACLsFilePath.toUri().getPath()).delete();
        for (String tip : tipsMap.keySet()) {
            Map attemptsMap = ((JobHistory.Task)tipsMap.get(tip)).getTaskAttempts();
            for (String attempt : attemptsMap.keySet()) {
                String taskLogURL = TaskLogServlet.getTaskLogUrl((String)"localhost", (String)((JobHistory.TaskAttempt)attemptsMap.get(attempt)).get(JobHistory.Keys.HTTP_PORT), (String)attempt.toString());
                TestWebUIAuthorization.assertEquals((String)"Incorrect return code for evilJohn", (int)200, (int)TestWebUIAuthorization.getHttpStatusCode(taskLogURL, unauthorizedUser, "GET"));
                File attemptLogDir = TaskLog.getAttemptDir((TaskAttemptID)TaskAttemptID.forName((String)attempt), (boolean)false);
                FileUtil.fullyDelete((File)attemptLogDir);
                TestWebUIAuthorization.assertEquals((String)"Incorrect return code for user1", (int)410, (int)TestWebUIAuthorization.getHttpStatusCode(taskLogURL, jobSubmitter, "GET"));
            }
        }
        String analyseJobHistoryJSP = jobHistoryUrl + "/analysejobhistory.jsp?logFile=" + urlEncodedHistoryFileName;
        this.validateViewJob(analyseJobHistoryJSP, "GET");
        String jobConfJSP = jobHistoryUrl + "/jobconf_history.jsp?logFile=" + urlEncodedHistoryFileName;
        this.validateViewJob(jobConfJSP, "GET");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateJobDetailsJSPKillJob(MiniMRCluster cluster, JobConf clusterConf, String jtURL) throws Exception {
        JobConf conf = new JobConf((Configuration)cluster.createJobConf());
        conf.set("mapreduce.job.acl-view-job", "colleague1 group3");
        conf.set("mapreduce.job.acl-modify-job", " group1,group3");
        String jobTrackerJSP = jtURL + "/jobtracker.jsp?a=b";
        RunningJob job = this.startSleepJobAsUser(jobSubmitter, conf, cluster);
        JobID jobid = job.getID();
        String url = jtURL + "/jobdetails.jsp?" + "action=kill&jobid=" + jobid.toString();
        try {
            TestWebUIAuthorization.assertEquals((int)401, (int)TestWebUIAuthorization.getHttpStatusCode(url, viewColleague, "POST"));
            TestWebUIAuthorization.assertEquals((int)401, (int)TestWebUIAuthorization.getHttpStatusCode(url, unauthorizedUser, "POST"));
            TestWebUIAuthorization.assertEquals((int)401, (int)TestWebUIAuthorization.getHttpStatusCode(url, modifyColleague, "POST"));
            TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, viewAndModifyColleague, "POST"));
            this.waitForKillJobToFinish(job);
            TestWebUIAuthorization.assertTrue((String)"killJob using jobdetails.jsp failed for a job for which user has job-view and job-modify permissions", (boolean)job.isComplete());
        }
        finally {
            if (!job.isComplete()) {
                LOG.info((Object)("Killing job " + jobid + " from finally block"));
                TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP + "&killJobs=true&jobCheckBox=" + jobid.toString(), jobSubmitter, "GET"));
            }
        }
        this.confirmJobDetailsJSPKillJobAsUser(cluster, conf, jtURL, jobTrackerJSP, jobSubmitter);
        this.confirmJobDetailsJSPKillJobAsUser(cluster, conf, jtURL, jobTrackerJSP, mrOwner);
        this.confirmJobDetailsJSPKillJobAsUser(cluster, conf, jtURL, jobTrackerJSP, mrAdminUser);
        this.confirmJobDetailsJSPKillJobAsUser(cluster, conf, jtURL, jobTrackerJSP, mrAdminGroupMember);
        this.confirmJobDetailsJSPKillJobAsUser(cluster, conf, jtURL, jobTrackerJSP, qAdmin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmJobTrackerJSPKillJobAsUser(MiniMRCluster cluster, JobConf conf, String jtURL, String user) throws Exception {
        String jobTrackerJSP = jtURL + "/jobtracker.jsp?a=b";
        RunningJob job = this.startSleepJobAsUser(jobSubmitter, conf, cluster);
        JobID jobid = job.getID();
        String url = jobTrackerJSP + "&killJobs=true&jobCheckBox=" + jobid.toString();
        try {
            TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, user, "POST"));
            this.waitForKillJobToFinish(job);
            TestWebUIAuthorization.assertTrue((String)"killJob failed for a job for which user has job-modify permission", (boolean)job.isComplete());
        }
        finally {
            if (!job.isComplete()) {
                LOG.info((Object)("Killing job " + jobid + " from finally block"));
                TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP + "&killJobs=true&jobCheckBox=" + jobid.toString(), jobSubmitter, "GET"));
            }
        }
    }

    void waitForKillJobToFinish(RunningJob job) throws IOException {
        while (!job.isComplete()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Interrupted while waiting for killJob() to finish for " + job.getID()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateKillMultipleJobs(MiniMRCluster cluster, JobConf conf, String jtURL) throws Exception {
        String jobTrackerJSP = jtURL + "/jobtracker.jsp?a=b";
        String url = jobTrackerJSP + "&killJobs=true";
        conf.set("mapreduce.job.acl-view-job", " ");
        conf.set("mapreduce.job.acl-modify-job", " ");
        RunningJob job1 = this.startSleepJobAsUser(jobSubmitter, conf, cluster);
        JobID jobid = job1.getID();
        url = url.concat("&jobCheckBox=" + jobid.toString());
        RunningJob job2 = this.startSleepJobAsUser(jobSubmitter1, conf, cluster);
        jobid = job2.getID();
        url = url.concat("&jobCheckBox=" + jobid.toString());
        RunningJob job3 = this.startSleepJobAsUser(jobSubmitter2, conf, cluster);
        jobid = job3.getID();
        url = url.concat("&jobCheckBox=" + jobid.toString());
        conf.set("mapreduce.job.acl-modify-job", jobSubmitter1);
        RunningJob job4 = this.startSleepJobAsUser(jobSubmitter3, conf, cluster);
        jobid = job4.getID();
        url = url.concat("&jobCheckBox=" + jobid.toString());
        try {
            TestWebUIAuthorization.assertEquals((int)401, (int)TestWebUIAuthorization.getHttpStatusCode(url, jobSubmitter1, "POST"));
            this.waitForKillJobToFinish(job2);
            TestWebUIAuthorization.assertTrue((String)"killJob failed for a job for which user has job-modify permission", (boolean)job2.isComplete());
            this.waitForKillJobToFinish(job4);
            TestWebUIAuthorization.assertTrue((String)"killJob failed for a job for which user has job-modify permission", (boolean)job4.isComplete());
            TestWebUIAuthorization.assertFalse((String)"killJob succeeded for a job for which user doesnot  have job-modify permission", (boolean)job1.isComplete());
            TestWebUIAuthorization.assertFalse((String)"killJob succeeded for a job for which user doesnot  have job-modify permission", (boolean)job3.isComplete());
        }
        finally {
            TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, mrOwner, "GET"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebUIAuthorization() throws Exception {
        TestWebUIAuthorization.setupGroupsProvider();
        Properties props = new Properties();
        props.setProperty("hadoop.http.filter.initializers", TestHttpServer.DummyFilterInitializer.class.getName());
        props.setProperty("mapred.acls.enabled", String.valueOf(true));
        props.setProperty(QueueManager.toFullPropertyName((String)"default", (String)QueueManager.QueueACL.ADMINISTER_JOBS.getAclName()), qAdmin);
        props.setProperty(QueueManager.toFullPropertyName((String)"default", (String)QueueManager.QueueACL.SUBMIT_JOB.getAclName()), "user1,user11,user12,user13");
        props.setProperty("dfs.permissions", "false");
        props.setProperty("mapred.tasktracker.map.tasks.maximum", "6");
        props.setProperty("webinterface.private.actions", "true");
        props.setProperty("mapreduce.cluster.administrators", "user4 admingroup");
        this.startCluster(true, props);
        MiniMRCluster cluster = this.getMRCluster();
        int infoPort = cluster.getJobTrackerRunner().getJobTrackerInfoPort();
        JobConf clusterConf = cluster.createJobConf();
        JobConf conf = new JobConf((Configuration)clusterConf);
        conf.set("mapreduce.job.acl-view-job", "colleague1 group3");
        conf.set("mapreduce.job.acl-modify-job", " group1,group3");
        RunningJob job = this.startSleepJobAsUser(jobSubmitter, conf, cluster);
        JobID jobid = job.getID();
        String jtURL = "http://localhost:" + infoPort;
        String jobTrackerJSP = jtURL + "/jobtracker.jsp?a=b";
        try {
            this.validateJobTrackerJSPAccess(jtURL);
            this.validateJobDetailsJSPAccess((org.apache.hadoop.mapreduce.JobID)jobid, jtURL);
            this.validateTaskGraphServletAccess((org.apache.hadoop.mapreduce.JobID)jobid, jtURL);
            this.validateJobTasksJSPAccess((org.apache.hadoop.mapreduce.JobID)jobid, jtURL);
            this.validateJobConfJSPAccess((org.apache.hadoop.mapreduce.JobID)jobid, jtURL);
            this.validateJobFailuresJSPAccess((org.apache.hadoop.mapreduce.JobID)jobid, jtURL);
            this.valiateJobBlacklistedTrackerJSPAccess((org.apache.hadoop.mapreduce.JobID)jobid, jtURL);
            this.validateJobTrackerJSPSetPriorityAction((org.apache.hadoop.mapreduce.JobID)jobid, jtURL);
            TaskID tipId = this.getTIPId(cluster, (org.apache.hadoop.mapreduce.JobID)jobid);
            this.validateTaskStatsJSPAccess((org.apache.hadoop.mapreduce.JobID)jobid, jtURL, tipId);
            this.validateTaskDetailsJSPAccess((org.apache.hadoop.mapreduce.JobID)jobid, jtURL, tipId);
            this.validateJobTrackerJSPKillJobAction(job, jtURL);
        }
        finally {
            if (!job.isComplete()) {
                LOG.info((Object)("Killing job " + jobid + " from finally block"));
                TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP + "&killJobs=true&jobCheckBox=" + jobid.toString(), jobSubmitter, "GET"));
            }
        }
        this.validateJobDetailsJSPKillJob(cluster, clusterConf, jtURL);
        this.confirmJobTrackerJSPKillJobAsUser(cluster, conf, jtURL, viewAndModifyColleague);
        this.confirmJobTrackerJSPKillJobAsUser(cluster, conf, jtURL, jobSubmitter);
        this.confirmJobTrackerJSPKillJobAsUser(cluster, conf, jtURL, mrOwner);
        this.confirmJobTrackerJSPKillJobAsUser(cluster, conf, jtURL, mrAdminUser);
        this.confirmJobTrackerJSPKillJobAsUser(cluster, conf, jtURL, mrAdminGroupMember);
        this.confirmJobTrackerJSPKillJobAsUser(cluster, conf, jtURL, qAdmin);
        this.validateKillMultipleJobs(cluster, conf, jtURL);
    }

    public void testWebUIAuthorizationForCommonServlets() throws Exception {
        TestWebUIAuthorization.setupGroupsProvider();
        Properties props = new Properties();
        props.setProperty("hadoop.http.filter.initializers", TestHttpServer.DummyFilterInitializer.class.getName());
        props.setProperty("hadoop.security.authorization", "true");
        props.setProperty("mapreduce.cluster.administrators", "user4 admingroup");
        this.startCluster(true, props);
        this.validateCommonServlets(this.getMRCluster());
    }

    private void validateCommonServlets(MiniMRCluster cluster) throws IOException {
        int infoPort = cluster.getJobTrackerRunner().getJobTrackerInfoPort();
        String jtURL = "http://localhost:" + infoPort;
        for (String servlet : new String[]{"logs", "stacks", "logLevel"}) {
            String url = jtURL + "/" + servlet;
            this.checkAccessToCommonServlet(url);
        }
        String ttURL = "http://localhost:" + cluster.getTaskTrackerRunner(0).getTaskTracker().getHttpPort();
        for (String servlet : new String[]{"logs", "stacks", "logLevel"}) {
            String url = ttURL + "/" + servlet;
            this.checkAccessToCommonServlet(url);
        }
    }

    private void checkAccessToCommonServlet(String url) throws IOException {
        url = url + "?a=b";
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, mrAdminUser, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, mrAdminGroupMember, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(url, mrOwner, "GET"));
        TestWebUIAuthorization.assertEquals((int)401, (int)TestWebUIAuthorization.getHttpStatusCode(url, jobSubmitter, "GET"));
    }

    private void validateJobTrackerJSPKillJobAction(RunningJob job, String jtURL) throws IOException {
        JobID jobid = job.getID();
        String jobTrackerJSP = jtURL + "/jobtracker.jsp?a=b";
        String jobTrackerJSPKillJobAction = jobTrackerJSP + "&killJobs=true&jobCheckBox=" + jobid.toString();
        this.validateModifyJob(jobTrackerJSPKillJobAction, "GET");
        this.waitForKillJobToFinish(job);
        TestWebUIAuthorization.assertTrue((String)"killJob failed for a job for which user has job-modify permission", (boolean)job.isComplete());
    }

    private void validateTaskDetailsJSPAccess(org.apache.hadoop.mapreduce.JobID jobid, String jtURL, TaskID tipId) throws IOException {
        String taskDetailsJSP = jtURL + "/taskdetails.jsp?jobid=" + jobid.toString() + "&tipid=" + tipId;
        this.validateViewJob(taskDetailsJSP, "GET");
    }

    private void validateTaskStatsJSPAccess(org.apache.hadoop.mapreduce.JobID jobid, String jtURL, TaskID tipId) throws IOException {
        String taskStatsJSP = jtURL + "/taskstats.jsp?jobid=" + jobid.toString() + "&tipid=" + tipId;
        this.validateViewJob(taskStatsJSP, "GET");
    }

    private void validateJobTrackerJSPSetPriorityAction(org.apache.hadoop.mapreduce.JobID jobid, String jtURL) throws IOException {
        String jobTrackerJSP = jtURL + "/jobtracker.jsp?a=b";
        String jobTrackerJSPSetJobPriorityAction = jobTrackerJSP + "&changeJobPriority=true&setJobPriority=" + "HIGH" + "&jobCheckBox=" + jobid.toString();
        this.validateModifyJob(jobTrackerJSPSetJobPriorityAction, "GET");
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSPSetJobPriorityAction, jobSubmitter, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSPSetJobPriorityAction, mrAdminUser, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSPSetJobPriorityAction, mrAdminGroupMember, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSPSetJobPriorityAction, qAdmin, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSPSetJobPriorityAction, mrOwner, "GET"));
    }

    private void valiateJobBlacklistedTrackerJSPAccess(org.apache.hadoop.mapreduce.JobID jobid, String jtURL) throws IOException {
        String jobBlacklistedTrackersJSP = jtURL + "/jobblacklistedtrackers.jsp?jobid=" + jobid.toString();
        this.validateViewJob(jobBlacklistedTrackersJSP, "GET");
    }

    private void validateJobFailuresJSPAccess(org.apache.hadoop.mapreduce.JobID jobid, String jtURL) throws IOException {
        String jobFailuresJSP = jtURL + "/jobfailures.jsp?jobid=" + jobid.toString();
        this.validateViewJob(jobFailuresJSP, "GET");
    }

    private void validateJobConfJSPAccess(org.apache.hadoop.mapreduce.JobID jobid, String jtURL) throws IOException {
        String jobConfJSP = jtURL + "/jobconf.jsp?jobid=" + jobid.toString();
        this.validateViewJob(jobConfJSP, "GET");
    }

    private void validateJobTasksJSPAccess(org.apache.hadoop.mapreduce.JobID jobid, String jtURL) throws IOException {
        String jobTasksJSP = jtURL + "/jobtasks.jsp?jobid=" + jobid.toString() + "&type=map&pagenum=1&state=running";
        this.validateViewJob(jobTasksJSP, "GET");
    }

    private void validateTaskGraphServletAccess(org.apache.hadoop.mapreduce.JobID jobid, String jtURL) throws IOException {
        String taskGraphServlet = jtURL + "/taskgraph?type=map&jobid=" + jobid.toString();
        this.validateViewJob(taskGraphServlet, "GET");
        taskGraphServlet = jtURL + "/taskgraph?type=reduce&jobid=" + jobid.toString();
        this.validateViewJob(taskGraphServlet, "GET");
    }

    private void validateJobDetailsJSPAccess(org.apache.hadoop.mapreduce.JobID jobid, String jtURL) throws IOException {
        String jobDetailsJSP = jtURL + "/jobdetails.jsp?jobid=" + jobid.toString();
        this.validateViewJob(jobDetailsJSP, "GET");
    }

    private void validateJobTrackerJSPAccess(String jtURL) throws IOException {
        String jobTrackerJSP = jtURL + "/jobtracker.jsp?a=b";
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP, jobSubmitter, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP, viewColleague, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP, unauthorizedUser, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP, modifyColleague, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP, viewAndModifyColleague, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP, mrOwner, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP, qAdmin, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP, mrAdminUser, "GET"));
        TestWebUIAuthorization.assertEquals((int)200, (int)TestWebUIAuthorization.getHttpStatusCode(jobTrackerJSP, mrAdminGroupMember, "GET"));
    }

    public static class MyGroupsProvider
    extends ShellBasedUnixGroupsMapping {
        static Map<String, List<String>> mapping = new HashMap<String, List<String>>();

        public List<String> getGroups(String user) throws IOException {
            return mapping.get(user);
        }
    }
}

