/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;

public class TestTextInputFormat
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)TestTextInputFormat.class.getName());
    private static int MAX_LENGTH = 10000;
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir;
    private static final Reporter voidReporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormat() throws Exception {
        JobConf job = new JobConf();
        Path file = new Path(workDir, "test.txt");
        Reporter reporter = Reporter.NULL;
        int seed = new Random().nextInt();
        LOG.info((Object)("seed = " + seed));
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            LOG.debug((Object)("creating; entries = " + length));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));
            try {
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            finally {
                ((Writer)writer).close();
            }
            TextInputFormat format = new TextInputFormat();
            format.configure(job);
            LongWritable key = new LongWritable();
            Text value = new Text();
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(MAX_LENGTH / 20) + 1;
                LOG.debug((Object)("splitting: requesting = " + numSplits));
                InputSplit[] splits = format.getSplits(job, numSplits);
                LOG.debug((Object)("splitting: got =        " + splits.length));
                if (length == 0) {
                    TestTextInputFormat.assertEquals((String)"Files of length 0 are not returned from FileInputFormat.getSplits().", (int)1, (int)splits.length);
                    TestTextInputFormat.assertEquals((String)"Empty file length == 0", (long)0L, (long)splits[0].getLength());
                }
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.length; ++j) {
                    LOG.debug((Object)("split[" + j + "]= " + splits[j]));
                    RecordReader reader = format.getRecordReader(splits[j], job, reporter);
                    try {
                        int count = 0;
                        while (reader.next((Object)key, (Object)value)) {
                            int v = Integer.parseInt(value.toString());
                            LOG.debug((Object)("read " + v));
                            if (bits.get(v)) {
                                LOG.warn((Object)("conflict with " + v + " in split " + j + " at position " + reader.getPos()));
                            }
                            TestTextInputFormat.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                            bits.set(v);
                            ++count;
                        }
                        LOG.debug((Object)("splits[" + j + "]=" + splits[j] + " count=" + count));
                        continue;
                    }
                    finally {
                        reader.close();
                    }
                }
                TestTextInputFormat.assertEquals((String)"Some keys in no partition.", (int)length, (int)bits.cardinality());
            }
        }
    }

    private static LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), (Configuration)defaultConf);
    }

    private static LineReader makeStream(String str, int bufsz) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), bufsz);
    }

    public void testUTF8() throws Exception {
        LineReader in = TestTextInputFormat.makeStream("abcd\u20acbdcd\u20ac");
        Text line = new Text();
        in.readLine(line);
        TestTextInputFormat.assertEquals((String)"readLine changed utf8 characters", (String)"abcd\u20acbdcd\u20ac", (String)line.toString());
        in = TestTextInputFormat.makeStream("abc\u200axyz");
        in.readLine(line);
        TestTextInputFormat.assertEquals((String)"split on fake newline", (String)"abc\u200axyz", (String)line.toString());
    }

    public void testNewLines() throws Exception {
        String STR = "a\nbb\n\nccc\rdddd\r\r\r\n\r\neeeee";
        int STRLENBYTES = "a\nbb\n\nccc\rdddd\r\r\r\n\r\neeeee".getBytes().length;
        Text out = new Text();
        for (int bufsz = 1; bufsz < STRLENBYTES + 1; ++bufsz) {
            LineReader in = TestTextInputFormat.makeStream("a\nbb\n\nccc\rdddd\r\r\r\n\r\neeeee", bufsz);
            int c = 0;
            c += in.readLine(out);
            TestTextInputFormat.assertEquals((String)("line1 length, bufsz:" + bufsz), (int)1, (int)out.getLength());
            c += in.readLine(out);
            TestTextInputFormat.assertEquals((String)("line2 length, bufsz:" + bufsz), (int)2, (int)out.getLength());
            c += in.readLine(out);
            TestTextInputFormat.assertEquals((String)("line3 length, bufsz:" + bufsz), (int)0, (int)out.getLength());
            c += in.readLine(out);
            TestTextInputFormat.assertEquals((String)("line4 length, bufsz:" + bufsz), (int)3, (int)out.getLength());
            c += in.readLine(out);
            TestTextInputFormat.assertEquals((String)("line5 length, bufsz:" + bufsz), (int)4, (int)out.getLength());
            c += in.readLine(out);
            TestTextInputFormat.assertEquals((String)("line6 length, bufsz:" + bufsz), (int)0, (int)out.getLength());
            c += in.readLine(out);
            TestTextInputFormat.assertEquals((String)("line7 length, bufsz:" + bufsz), (int)0, (int)out.getLength());
            c += in.readLine(out);
            TestTextInputFormat.assertEquals((String)("line8 length, bufsz:" + bufsz), (int)0, (int)out.getLength());
            TestTextInputFormat.assertEquals((String)("line9 length, bufsz:" + bufsz), (int)5, (int)out.getLength());
            TestTextInputFormat.assertEquals((String)("end of file, bufsz: " + bufsz), (int)0, (int)in.readLine(out));
            TestTextInputFormat.assertEquals((String)("total bytes, bufsz: " + bufsz), (int)(c += in.readLine(out)), (int)STRLENBYTES);
        }
    }

    public void testMaxLineLength() throws Exception {
        String STR = "a\nbb\n\nccc\rdddd\r\neeeee";
        int STRLENBYTES = "a\nbb\n\nccc\rdddd\r\neeeee".getBytes().length;
        Text out = new Text();
        for (int bufsz = 1; bufsz < STRLENBYTES + 1; ++bufsz) {
            LineReader in = TestTextInputFormat.makeStream("a\nbb\n\nccc\rdddd\r\neeeee", bufsz);
            int c = 0;
            c += in.readLine(out, 1);
            TestTextInputFormat.assertEquals((String)("line1 length, bufsz: " + bufsz), (int)1, (int)out.getLength());
            c += in.readLine(out, 1);
            TestTextInputFormat.assertEquals((String)("line2 length, bufsz: " + bufsz), (int)1, (int)out.getLength());
            c += in.readLine(out, 1);
            TestTextInputFormat.assertEquals((String)("line3 length, bufsz: " + bufsz), (int)0, (int)out.getLength());
            c += in.readLine(out, 3);
            TestTextInputFormat.assertEquals((String)("line4 length, bufsz: " + bufsz), (int)3, (int)out.getLength());
            c += in.readLine(out, 10);
            TestTextInputFormat.assertEquals((String)("line5 length, bufsz: " + bufsz), (int)4, (int)out.getLength());
            TestTextInputFormat.assertEquals((String)("line5 length, bufsz: " + bufsz), (int)5, (int)out.getLength());
            TestTextInputFormat.assertEquals((String)("end of file, bufsz: " + bufsz), (int)0, (int)in.readLine(out));
            TestTextInputFormat.assertEquals((String)("total bytes, bufsz: " + bufsz), (int)(c += in.readLine(out, 8)), (int)STRLENBYTES);
        }
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(TextInputFormat format, InputSplit split, JobConf job) throws IOException {
        ArrayList<Text> result = new ArrayList<Text>();
        RecordReader reader = format.getRecordReader(split, job, voidReporter);
        LongWritable key = (LongWritable)reader.createKey();
        Text value = (Text)reader.createValue();
        while (reader.next((Object)key, (Object)value)) {
            result.add(value);
            value = (Text)reader.createValue();
        }
        reader.close();
        return result;
    }

    public static void testGzip() throws IOException {
        JobConf job = new JobConf();
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        localFs.delete(workDir, true);
        TestTextInputFormat.writeFile(localFs, new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, "the quick\nbrown\nfox jumped\nover\n the lazy\n dog\n");
        TestTextInputFormat.writeFile(localFs, new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, "this is a test\nof gzip\n");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        TextInputFormat format = new TextInputFormat();
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 100);
        TestTextInputFormat.assertEquals((String)"compressed splits == 2", (int)2, (int)splits.length);
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List<Text> results = TestTextInputFormat.readSplit(format, splits[0], job);
        TestTextInputFormat.assertEquals((String)"splits[0] length", (int)6, (int)results.size());
        TestTextInputFormat.assertEquals((String)"splits[0][5]", (String)" dog", (String)results.get(5).toString());
        results = TestTextInputFormat.readSplit(format, splits[1], job);
        TestTextInputFormat.assertEquals((String)"splits[1] length", (int)2, (int)results.size());
        TestTextInputFormat.assertEquals((String)"splits[1][0]", (String)"this is a test", (String)results.get(0).toString());
        TestTextInputFormat.assertEquals((String)"splits[1][1]", (String)"of gzip", (String)results.get(1).toString());
    }

    public static void testGzipEmpty() throws IOException {
        JobConf job = new JobConf();
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        localFs.delete(workDir, true);
        TestTextInputFormat.writeFile(localFs, new Path(workDir, "empty.gz"), (CompressionCodec)gzip, "");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        TextInputFormat format = new TextInputFormat();
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 100);
        TestTextInputFormat.assertEquals((String)"Compressed files of length 0 are not returned from FileInputFormat.getSplits().", (int)1, (int)splits.length);
        List<Text> results = TestTextInputFormat.readSplit(format, splits[0], job);
        TestTextInputFormat.assertEquals((String)"Compressed empty file length == 0", (int)0, (int)results.size());
    }

    private static String unquote(String in) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch == '\\') {
                ch = in.charAt(++i);
                switch (ch) {
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    default: {
                        result.append(ch);
                        break;
                    }
                }
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            System.out.println("Working on " + arg);
            LineReader reader = TestTextInputFormat.makeStream(TestTextInputFormat.unquote(arg));
            Text line = new Text();
            int size = reader.readLine(line);
            while (size > 0) {
                System.out.println("Got: " + line.toString());
                size = reader.readLine(line);
            }
            reader.close();
        }
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestTextInputFormat");
        voidReporter = Reporter.NULL;
    }
}

