/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.KillTaskAction;
import org.apache.hadoop.mapred.LaunchTaskAction;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.TaskType;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskLauncher {
    private static int expectedLaunchAttemptId = 1;

    @Test
    public void testExternalKillForLaunchTask() throws IOException {
        JobConf ttConf = new JobConf();
        ttConf.setInt("mapred.tasktracker.map.tasks.maximum", 4);
        MyTaskTracker tt = new MyTaskTracker();
        tt.runningJobs = new TreeMap();
        tt.runningTasks = new LinkedHashMap();
        tt.setIndexCache(new IndexCache(ttConf));
        tt.setTaskMemoryManagerEnabledFlag();
        MyTaskTracker myTaskTracker = tt;
        ((Object)((Object)myTaskTracker)).getClass();
        TaskTracker.TaskLauncher mapLauncher = new TaskTracker.TaskLauncher((TaskTracker)myTaskTracker, TaskType.MAP, 4);
        mapLauncher.start();
        String jtId = "test";
        TaskAttemptID attemptID = new TaskAttemptID(jtId, 1, true, 0, 0);
        MapTask task = new MapTask(null, attemptID, 0, null, 5);
        mapLauncher.addToTaskQueue(new LaunchTaskAction((Task)task));
        TaskTracker.TaskInProgress killTip = (TaskTracker.TaskInProgress)tt.runningTasks.get(attemptID);
        Assert.assertNotNull((Object)killTip);
        for (int i = 0; i < 300 && mapLauncher.getNumWaitingTasksToLaunch() != 0; ++i) {
            UtilsForTests.waitFor(100L);
        }
        Assert.assertEquals((String)("Launcher didnt pick up the task " + attemptID + "to launch"), (long)0L, (long)mapLauncher.getNumWaitingTasksToLaunch());
        tt.processKillTaskAction(new KillTaskAction(attemptID));
        Assert.assertEquals((Object)TaskStatus.State.KILLED, (Object)killTip.getRunState());
        TaskAttemptID runningAttemptID = new TaskAttemptID(jtId, 1, true, 0, expectedLaunchAttemptId);
        mapLauncher.addToTaskQueue(new LaunchTaskAction((Task)new MapTask(null, runningAttemptID, 0, null, 1)));
        TaskTracker.TaskInProgress runningTip = (TaskTracker.TaskInProgress)tt.runningTasks.get(runningAttemptID);
        Assert.assertNotNull((Object)runningTip);
        for (int i = 0; i < 300 && !runningTip.getRunState().equals((Object)TaskStatus.State.RUNNING); ++i) {
            UtilsForTests.waitFor(100L);
        }
        Assert.assertEquals((Object)TaskStatus.State.RUNNING, (Object)runningTip.getRunState());
    }

    private static class MyTaskTracker
    extends TaskTracker {
        private MyTaskTracker() {
        }

        void startNewTask(TaskTracker.TaskInProgress tip) {
            Assert.assertEquals((long)expectedLaunchAttemptId, (long)tip.getTask().getTaskID().getId());
            tip.getStatus().setRunState(TaskStatus.State.RUNNING);
        }
    }
}

