/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.security.UserGroupInformation;

public class TestQueueAclsForCurrentUser
extends TestCase {
    private QueueManager queueManager;
    private JobConf conf = null;
    UserGroupInformation currentUGI = null;
    String submitAcl = QueueManager.QueueACL.SUBMIT_JOB.getAclName();
    String adminAcl = QueueManager.QueueACL.ADMINISTER_JOBS.getAclName();

    private void setupConfForNoAccess() throws IOException, LoginException {
        this.currentUGI = UserGroupInformation.getLoginUser();
        String userName = this.currentUGI.getUserName();
        this.conf = new JobConf();
        this.conf.setBoolean("mapred.acls.enabled", true);
        this.conf.set("mapred.queue.names", "qu1,qu2");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu1", (String)this.submitAcl), "u1");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu1", (String)this.adminAcl), "u1");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu2", (String)this.submitAcl), " g2");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu2", (String)this.adminAcl), " g2");
        this.queueManager = new QueueManager((Configuration)this.conf);
    }

    private void setupConf(boolean aclSwitch) throws IOException, LoginException {
        this.currentUGI = UserGroupInformation.getLoginUser();
        String userName = this.currentUGI.getUserName();
        this.conf = new JobConf();
        this.conf.setBoolean("mapred.acls.enabled", aclSwitch);
        this.conf.set("mapred.queue.names", "qu1,qu2,qu3,qu4,qu5,qu6,qu7");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu1", (String)this.submitAcl), "*");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu1", (String)this.adminAcl), "*");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu2", (String)this.submitAcl), "u2");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu2", (String)this.adminAcl), "u2");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu3", (String)this.submitAcl), "u2");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu3", (String)this.adminAcl), "*");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu4", (String)this.submitAcl), "*");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu4", (String)this.adminAcl), "u2");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu6", (String)this.submitAcl), userName);
        this.conf.set(QueueManager.toFullPropertyName((String)"qu6", (String)this.adminAcl), "u2");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu7", (String)this.submitAcl), "u2");
        this.conf.set(QueueManager.toFullPropertyName((String)"qu7", (String)this.adminAcl), userName);
        StringBuilder groupNames = new StringBuilder("");
        String[] ugiGroupNames = this.currentUGI.getGroupNames();
        int max = ugiGroupNames.length - 1;
        for (int j = 0; j < ugiGroupNames.length; ++j) {
            groupNames.append(ugiGroupNames[j]);
            if (j >= max) continue;
            groupNames.append(",");
        }
        this.conf.set(QueueManager.toFullPropertyName((String)"qu5", (String)this.submitAcl), " " + groupNames.toString());
        this.conf.set(QueueManager.toFullPropertyName((String)"qu5", (String)this.adminAcl), " " + groupNames.toString());
        this.queueManager = new QueueManager((Configuration)this.conf);
    }

    public void testQueueAclsForCurrentuser() throws IOException, LoginException {
        this.setupConf(true);
        QueueAclsInfo[] queueAclsInfoList = this.queueManager.getQueueAcls(this.currentUGI);
        this.checkQueueAclsInfo(queueAclsInfoList);
    }

    public void testQueueAclsForCurrentUserAclsDisabled() throws IOException, LoginException {
        this.setupConf(false);
        QueueAclsInfo[] queueAclsInfoList = this.queueManager.getQueueAcls(this.currentUGI);
        this.checkQueueAclsInfo(queueAclsInfoList);
    }

    public void testQueueAclsForNoAccess() throws IOException, LoginException {
        this.setupConfForNoAccess();
        QueueAclsInfo[] queueAclsInfoList = this.queueManager.getQueueAcls(this.currentUGI);
        TestQueueAclsForCurrentUser.assertTrue((queueAclsInfoList.length == 0 ? 1 : 0) != 0);
    }

    private void checkQueueAclsInfo(QueueAclsInfo[] queueAclsInfoList) throws IOException {
        if (this.conf.get("mapred.acls.enabled").equalsIgnoreCase("true")) {
            for (int i = 0; i < queueAclsInfoList.length; ++i) {
                QueueAclsInfo acls = queueAclsInfoList[i];
                String queueName = acls.getQueueName();
                TestQueueAclsForCurrentUser.assertFalse((boolean)queueName.contains("qu2"));
                if (queueName.equals("qu1")) {
                    TestQueueAclsForCurrentUser.assertTrue((acls.getOperations().length == 2 ? 1 : 0) != 0);
                    TestQueueAclsForCurrentUser.assertTrue((boolean)this.checkAll(acls.getOperations()));
                    continue;
                }
                if (queueName.equals("qu3")) {
                    TestQueueAclsForCurrentUser.assertTrue((acls.getOperations().length == 1 ? 1 : 0) != 0);
                    TestQueueAclsForCurrentUser.assertTrue((boolean)acls.getOperations()[0].equalsIgnoreCase(this.adminAcl));
                    continue;
                }
                if (queueName.equals("qu4")) {
                    TestQueueAclsForCurrentUser.assertTrue((acls.getOperations().length == 1 ? 1 : 0) != 0);
                    TestQueueAclsForCurrentUser.assertTrue((boolean)acls.getOperations()[0].equalsIgnoreCase(this.submitAcl));
                    continue;
                }
                if (queueName.equals("qu5")) {
                    TestQueueAclsForCurrentUser.assertTrue((acls.getOperations().length == 2 ? 1 : 0) != 0);
                    TestQueueAclsForCurrentUser.assertTrue((boolean)this.checkAll(acls.getOperations()));
                    continue;
                }
                if (queueName.equals("qu6")) {
                    TestQueueAclsForCurrentUser.assertTrue((boolean)acls.getOperations()[0].equals(this.submitAcl));
                    continue;
                }
                if (!queueName.equals("qu7")) continue;
                TestQueueAclsForCurrentUser.assertTrue((boolean)acls.getOperations()[0].equals(this.adminAcl));
            }
        } else {
            for (int i = 0; i < queueAclsInfoList.length; ++i) {
                QueueAclsInfo acls = queueAclsInfoList[i];
                String queueName = acls.getQueueName();
                TestQueueAclsForCurrentUser.assertTrue((acls.getOperations().length == 2 ? 1 : 0) != 0);
                TestQueueAclsForCurrentUser.assertTrue((boolean)this.checkAll(acls.getOperations()));
            }
        }
    }

    private boolean checkAll(String[] operations) {
        boolean submit = false;
        boolean admin = false;
        for (String val : operations) {
            if (val.equalsIgnoreCase(this.submitAcl)) {
                submit = true;
                continue;
            }
            if (!val.equalsIgnoreCase(this.adminAcl)) continue;
            admin = true;
        }
        return submit && admin;
    }
}

