/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class TestNodeBlacklisting
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestNodeBlacklisting.class);
    private static final Path TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"), "node-bklisting");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBlacklistedNodeDecommissioning() throws Exception {
        LOG.info((Object)"Testing blacklisted node decommissioning");
        MiniMRCluster mr = null;
        JobTracker jt = null;
        try {
            JobConf jtConf = new JobConf();
            jtConf.set("mapred.max.tracker.blacklists", "1");
            mr = new MiniMRCluster(0, 0, 2, "file:///", 1, null, null, null, jtConf);
            jt = mr.getJobTrackerRunner().getJobTracker();
            TestNodeBlacklisting.assertEquals((String)"Trackers not up", (int)2, (int)jt.taskTrackers().size());
            TestNodeBlacklisting.assertEquals((String)"Active tracker count mismatch", (int)2, (int)jt.getClusterStatus(false).getTaskTrackers());
            TestNodeBlacklisting.assertEquals((String)"Blacklisted tracker count mismatch", (int)0, (int)jt.getClusterStatus(false).getBlacklistedTrackers());
            JobConf jConf = mr.createJobConf();
            jConf.set("mapred.max.tracker.failures", "1");
            jConf.setJobName("test-job-fail-once");
            jConf.setMapperClass(FailOnceMapper.class);
            jConf.setReducerClass(IdentityReducer.class);
            jConf.setNumMapTasks(1);
            jConf.setNumReduceTasks(0);
            RunningJob job = UtilsForTests.runJob(jConf, new Path(TEST_DIR, "in"), new Path(TEST_DIR, "out"));
            job.waitForCompletion();
            TestNodeBlacklisting.assertEquals((String)"Active tracker count mismatch", (int)2, (int)jt.getClusterStatus(false).getTaskTrackers());
            TestNodeBlacklisting.assertEquals((String)"Graylisted tracker count mismatch", (int)1, (int)jt.getClusterStatus(false).getGraylistedTrackers());
            String trackerName = null;
            for (TaskTrackerStatus status : jt.taskTrackers()) {
                if (!jt.isGraylisted(status.getTrackerName())) continue;
                trackerName = status.getTrackerName();
                break;
            }
            String hostToDecommission = JobInProgress.convertTrackerNameToHostName(trackerName);
            LOG.info((Object)("Decommissioning tracker " + hostToDecommission));
            HashSet<String> decom = new HashSet<String>(1);
            decom.add(hostToDecommission);
            jt.decommissionNodes(decom);
            TestNodeBlacklisting.assertEquals((String)"Tracker is not lost upon host decommissioning", (int)1, (int)jt.getClusterStatus(false).getTaskTrackers());
            TestNodeBlacklisting.assertEquals((String)"Graylisted tracker count incorrect in cluster status after decommissioning", (int)0, (int)jt.getClusterStatus(false).getGraylistedTrackers());
            TestNodeBlacklisting.assertEquals((String)"Tracker is not lost upon host decommissioning", (int)1, (int)jt.taskTrackers().size());
        }
        finally {
            if (mr != null) {
                mr.shutdown();
                mr = null;
                jt = null;
                FileUtil.fullyDelete((File)new File(TEST_DIR.toString()));
            }
        }
    }

    static class FailOnceMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        private boolean shouldFail = false;

        FailOnceMapper() {
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
            if (this.shouldFail) {
                throw new RuntimeException("failing map");
            }
        }

        public void configure(JobConf conf) {
            TaskAttemptID id = TaskAttemptID.forName((String)conf.get("mapred.task.id"));
            this.shouldFail = id.getId() == 0 && id.getTaskID().getId() == 0;
        }
    }
}

