/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutput;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.LinuxTaskController;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskTracker;

public class TestLinuxTaskControllerLaunchArgs
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestLinuxTaskControllerLaunchArgs.class);
    private static File testDir = new File(System.getProperty("test.build.data", "/tmp"), TestLinuxTaskControllerLaunchArgs.class.getName());
    private static File fakeTaskController = new File(testDir, "faketc.sh");
    private static File mapredLocal = new File(testDir, "mapred/local");
    private TaskController ltc;
    private boolean initialized = false;
    private String user = new String("testuser");
    private InetSocketAddress addr = new InetSocketAddress("localhost", 3209);
    Configuration conf = new Configuration();

    protected void createFakeTCScript() throws Exception {
        FileWriter out = new FileWriter(fakeTaskController);
        out.write("#!/bin/bash\n");
        out.write("if [ $# -eq 0 ]; then exit 1; fi\n");
        out.write("for LARG in \"$@\"\n");
        out.write("do case \"$LARG\" in\n");
        out.write("*/java) LTC_ARG1=1;;\n");
        out.write("-classpath) LTC_ARG2=1;;\n");
        out.write("-Dhadoop.log.dir*) LTC_ARG3=1;;\n");
        out.write("-Dhadoop.root.logger*) LTC_ARG4=1;;\n");
        out.write("-Djava.library.path*) LTC_ARG5=1;;\n");
        out.write("esac; done\n");
        out.write("LTC_ARGS=$((LTC_ARG1+LTC_ARG2+LTC_ARG3+LTC_ARG4+LTC_ARG5))\n");
        out.write("if [ $LTC_ARGS -eq 5 ]; then exit 0; else exit 22; fi\n");
        out.close();
        fakeTaskController.setExecutable(true);
    }

    protected void initMyTest() throws Exception {
        testDir.mkdirs();
        mapredLocal.mkdirs();
        this.createFakeTCScript();
        this.conf.set("mapred.local.dir", mapredLocal.toString());
        this.conf.set("mapreduce.tasktracker.task-controller.exe", fakeTaskController.toString());
        this.ltc = new LinuxTaskController();
        this.ltc.setConf(this.conf);
        try {
            this.ltc.setup(new LocalDirAllocator(mapredLocal.toString()), new TaskTracker.LocalStorage(new String[]{mapredLocal.toString()}));
        }
        catch (IOException ie) {
            TestLinuxTaskControllerLaunchArgs.fail((String)"Error running task-controller from setup().");
        }
        this.initialized = true;
    }

    public void testLTCCallInitializeJob() throws Exception {
        if (!this.initialized) {
            this.initMyTest();
        }
        try {
            this.ltc.initializeJob(this.user, new String("jobid"), new Path("/cred.xml"), new Path("/job.xml"), null, this.addr);
        }
        catch (IOException ie) {
            TestLinuxTaskControllerLaunchArgs.fail((String)"Missing argument when running task-controller from initializeJob().\n");
        }
    }

    public void testLTCCallTruncateLogsAsUser() throws Exception {
        if (!this.initialized) {
            this.initMyTest();
        }
        ArrayList<MyMapTask> tasks = new ArrayList<MyMapTask>();
        tasks.add(new MyMapTask());
        try {
            this.ltc.truncateLogsAsUser(this.user, tasks);
        }
        catch (IOException ie) {
            TestLinuxTaskControllerLaunchArgs.fail((String)"Missing argument when running task-controller from truncateLogsAsUser()\n");
        }
    }

    public static class MyMapTask
    extends MapTask {
        public void write(DataOutput out) throws IOException {
        }
    }
}

