/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LimitTasksPerJobTaskScheduler;
import org.apache.hadoop.mapred.TaskScheduler;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TestJobQueueTaskScheduler;

public class TestLimitTasksPerJobTaskScheduler
extends TestCase {
    protected JobConf jobConf;
    protected TaskScheduler scheduler;
    private TestJobQueueTaskScheduler.FakeTaskTrackerManager taskTrackerManager;

    protected void setUp() throws Exception {
        TestJobQueueTaskScheduler.resetCounters();
        this.jobConf = new JobConf();
        this.jobConf.setNumMapTasks(10);
        this.jobConf.setNumReduceTasks(10);
        this.taskTrackerManager = new TestJobQueueTaskScheduler.FakeTaskTrackerManager();
        this.scheduler = this.createTaskScheduler();
        this.scheduler.setConf((Configuration)this.jobConf);
        this.scheduler.setTaskTrackerManager((TaskTrackerManager)this.taskTrackerManager);
        this.scheduler.start();
    }

    protected void tearDown() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.terminate();
        }
    }

    protected TaskScheduler createTaskScheduler() {
        return new LimitTasksPerJobTaskScheduler();
    }

    public void testMaxRunningTasksPerJob() throws IOException {
        this.jobConf.setLong("mapred.jobtracker.taskScheduler.maxRunningTasksPerJob", 4L);
        this.scheduler.setConf((Configuration)this.jobConf);
        TestJobQueueTaskScheduler.submitJobs(this.taskTrackerManager, this.jobConf, 2, 1);
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0001_m_000001_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0001_m_000002_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0001_r_000003_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0001_r_000004_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0002_m_000005_0 on tt2"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0002_m_000006_0 on tt2"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0002_r_000007_0 on tt2"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0002_r_000008_0 on tt2"});
    }

    public void testMaxRunningTasksPerJobWithInterleavedTrackers() throws IOException {
        this.jobConf.setLong("mapred.jobtracker.taskScheduler.maxRunningTasksPerJob", 4L);
        this.scheduler.setConf((Configuration)this.jobConf);
        TestJobQueueTaskScheduler.submitJobs(this.taskTrackerManager, this.jobConf, 2, 1);
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0001_m_000001_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0001_m_000002_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0001_m_000003_0 on tt2"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0001_r_000004_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0002_m_000005_0 on tt2"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt1"), new String[]{"attempt_test_0002_r_000006_0 on tt1"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0002_r_000007_0 on tt2"});
        TestJobQueueTaskScheduler.checkAssignment(this.scheduler, TestJobQueueTaskScheduler.tracker(this.taskTrackerManager, "tt2"), new String[]{"attempt_test_0002_r_000008_0 on tt2"});
    }
}

