/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.DefaultJobHistoryParser;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;

public class TestJobHistoryVersion
extends TestCase {
    private static final String HOSTNAME = "localhost";
    private static final String TIME = "1234567890123";
    private static final String USER = "user";
    private static final String JOBNAME = "job";
    private static final String JOB = "job_200809180000_0001";
    private static final String FILENAME = "localhost_1234567890123_job_200809180000_0001_user_job";
    private static final String TASK_ID = "tip_200809180000_0001_0";
    private static final String TASK_ATTEMPT_ID = "attempt_200809180000_0001_0_1234567890123";
    private static final String COUNTERS = "Job Counters.Launched map tasks:1,Map-Reduce Framework.Map input records:0,Map-Reduce Framework.Map input bytes:0,File Systems.HDFS bytes written:0,";
    private static final Path TEST_DIR = new Path(System.getProperty("test.build.data", "/tmp"), "test-history-version");
    private static final String DELIM = ".";

    private void writeHistoryFile(FSDataOutputStream out, long version) throws IOException {
        String delim = "\n";
        String counters = COUNTERS;
        String jobConf = "job.xml";
        if (version > 0L) {
            delim = DELIM + delim;
            out.writeBytes(JobHistory.RecordTypes.Meta.name() + " VERSION=\"" + 1L + "\" " + delim);
            jobConf = JobHistory.escapeString((String)jobConf);
            counters = JobHistory.escapeString((String)counters);
        }
        out.writeBytes("Job JOBID=\"job_200809180000_0001\" JOBNAME=\"job\" USER=\"user\" SUBMIT_TIME=\"1234567890123\" JOBCONF=\"" + jobConf + "\" " + delim);
        out.writeBytes("Job JOBID=\"job_200809180000_0001\" LAUNCH_TIME=\"1234567890123\" TOTAL_MAPS=\"1\" TOTAL_REDUCES=\"0\" " + delim);
        out.writeBytes("Task TASKID=\"tip_200809180000_0001_0\" TASK_TYPE=\"MAP\" START_TIME=\"1234567890123\" SPLITS=\"\" TOTAL_MAPS=\"1\" TOTAL_REDUCES=\"0\" " + delim);
        out.writeBytes("MapAttempt TASK_TYPE=\"MAP\" TASKID=\"tip_200809180000_0001_0\" TASK_ATTEMPT_ID=\"attempt_200809180000_0001_0_1234567890123\" START_TIME=\"1234567890123\" HOSTNAME=\"localhost\" " + delim);
        out.writeBytes("MapAttempt TASK_TYPE=\"MAP\" TASKID=\"tip_200809180000_0001_0\" TASK_ATTEMPT_ID=\"attempt_200809180000_0001_0_1234567890123\" FINISH_TIME=\"1234567890123\" TASK_STATUS=\"SUCCESS\" HOSTNAME=\"localhost\" " + delim);
        out.writeBytes("Task TASKID=\"tip_200809180000_0001_0\" TASK_TYPE=\"MAP\" TASK_STATUS=\"SUCCESS\" FINISH_TIME=\"1234567890123\" COUNTERS=\"" + counters + "\" " + delim);
        out.writeBytes("Job JOBID=\"job_200809180000_0001\" FINISH_TIME=\"1234567890123\" TOTAL_MAPS=\"1\" TOTAL_REDUCES=\"0\" JOB_STATUS=\"SUCCESS\" FINISHED_MAPS=\"1\" FINISHED_REDUCES=\"0\" FAILED_MAPS=\"0\" FAILED_REDUCES=\"0\" COUNTERS=\"" + counters + "\" " + delim);
    }

    public void testJobHistoryVersion() throws IOException {
        for (long version = 0L; version <= 1L; ++version) {
            JobConf conf = new JobConf();
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            fs.delete(TEST_DIR, true);
            Path historyPath = new Path(TEST_DIR + "/_logs/history/" + FILENAME + version);
            fs.delete(historyPath, false);
            FSDataOutputStream out = fs.create(historyPath);
            this.writeHistoryFile(out, version);
            out.close();
            JobHistory.JobInfo job = new JobHistory.JobInfo(JOB);
            DefaultJobHistoryParser.parseJobTasks((String)historyPath.toString(), (JobHistory.JobInfo)job, (FileSystem)fs);
            TestJobHistoryVersion.assertTrue((String)("Failed to parse jobhistory files of version " + version), (job.getAllTasks().size() > 0 ? 1 : 0) != 0);
            fs.delete(TEST_DIR, true);
        }
    }
}

