/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.ClusterMapReduceTestCase;
import org.apache.hadoop.mapred.ControlledMapReduceJob;
import org.apache.hadoop.mapred.JobInProgress;

public class TestControlledMapReduceJob
extends ClusterMapReduceTestCase {
    static final Log LOG = LogFactory.getLog(TestControlledMapReduceJob.class);

    public void testControlledMapReduceJob() throws Exception {
        Properties props = new Properties();
        props.setProperty("mapred.tasktracker.map.tasks.maximum", "2");
        props.setProperty("mapred.tasktracker.reduce.tasks.maximum", "2");
        this.startCluster(true, props);
        LOG.info((Object)"Started the cluster");
        ControlledMapReduceJob.ControlledMapReduceJobRunner jobRunner = ControlledMapReduceJob.ControlledMapReduceJobRunner.getControlledMapReduceJobRunner(this.createJobConf(), 7, 6);
        jobRunner.start();
        ControlledMapReduceJob controlledJob = jobRunner.getJob();
        JobInProgress jip = this.getMRCluster().getJobTrackerRunner().getJobTracker().getJob(jobRunner.getJobID());
        ControlledMapReduceJob.waitTillNTasksStartRunning(jip, true, 4);
        LOG.info((Object)"Finishing 3 maps");
        controlledJob.finishNTasks(true, 3);
        ControlledMapReduceJob.waitTillNTotalTasksFinish(jip, true, 3);
        ControlledMapReduceJob.waitTillNTasksStartRunning(jip, true, 4);
        LOG.info((Object)"Finishing 4 more maps");
        controlledJob.finishNTasks(true, 4);
        ControlledMapReduceJob.waitTillNTotalTasksFinish(jip, true, 7);
        ControlledMapReduceJob.waitTillNTasksStartRunning(jip, false, 4);
        LOG.info((Object)"Finishing 2 reduces");
        controlledJob.finishNTasks(false, 2);
        ControlledMapReduceJob.waitTillNTotalTasksFinish(jip, false, 2);
        ControlledMapReduceJob.waitTillNTasksStartRunning(jip, false, 4);
        LOG.info((Object)"Finishing 4 more reduces");
        controlledJob.finishNTasks(false, 4);
        ControlledMapReduceJob.waitTillNTotalTasksFinish(jip, false, 6);
        jobRunner.join();
    }
}

