/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BloomMapFile;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class TestBloomMapFile
extends TestCase {
    private static Configuration conf = new Configuration();

    public void testMembershipTest() throws Exception {
        Path dirName = new Path(System.getProperty("test.build.data", ".") + this.getName() + ".bloommapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        conf.setInt("io.mapfile.bloom.size", 2048);
        BloomMapFile.Writer writer = new BloomMapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), IntWritable.class, Text.class);
        IntWritable key = new IntWritable();
        Text value = new Text();
        for (int i = 0; i < 2000; i += 2) {
            key.set(i);
            value.set("00" + i);
            writer.append((WritableComparable)key, (Writable)value);
        }
        writer.close();
        BloomMapFile.Reader reader = new BloomMapFile.Reader((FileSystem)fs, qualifiedDirName.toString(), conf);
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            key.set(i);
            boolean exists = reader.probablyHasKey((WritableComparable)key);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        reader.close();
        fs.delete(qualifiedDirName, true);
        System.out.println("False negatives: " + falseNeg);
        TestBloomMapFile.assertEquals((int)0, (int)falseNeg);
        System.out.println("False positives: " + falsePos);
        TestBloomMapFile.assertTrue((falsePos < 2 ? 1 : 0) != 0);
    }
}

