/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDatanodeBlockScanner;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;

public class TestOverReplicatedBlocks
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProcesOverReplicateBlock() throws IOException {
        Configuration conf = new Configuration();
        conf.setLong("dfs.blockreport.intervalMsec", 1000L);
        conf.set("dfs.replication.pending.timeout.sec", Integer.toString(2));
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 3, true, null);
        FileSystem fs = cluster.getFileSystem();
        try {
            Path fileName = new Path("/foo1");
            DFSTestUtil.createFile(fs, fileName, 2L, (short)3, 0L);
            DFSTestUtil.waitReplication(fs, fileName, (short)3);
            Block block = DFSTestUtil.getFirstBlock(fs, fileName);
            TestDatanodeBlockScanner.corruptReplica(block.getBlockName(), 0);
            MiniDFSCluster.DataNodeProperties dnProps = cluster.stopDataNode(0);
            File scanLog = new File(System.getProperty("test.build.data"), "dfs/data/data1/current/dncp_block_verification.log.curr");
            int i = 0;
            while (!scanLog.delete()) {
                TestOverReplicatedBlocks.assertTrue((String)"Could not delete log file in one minute", (i < 60 ? 1 : 0) != 0);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                ++i;
            }
            cluster.restartDataNode(dnProps);
            DFSTestUtil.waitReplication(fs, fileName, (short)2);
            DatanodeRegistration corruptDataNode = cluster.getDataNodes().get((int)2).dnRegistration;
            FSNamesystem namesystem = FSNamesystem.getFSNamesystem();
            ArrayList arrayList = namesystem.heartbeats;
            synchronized (arrayList) {
                for (DatanodeDescriptor datanode : namesystem.heartbeats) {
                    if (corruptDataNode.equals((Object)datanode)) continue;
                    datanode.updateHeartbeat(100L, 100L, 0L, 0);
                }
                namesystem.setReplication(fileName.toString(), (short)1);
                TestOverReplicatedBlocks.assertEquals((int)1, (int)namesystem.countNodes(block).liveReplicas());
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

