/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJspHelper {
    private Configuration conf = new Configuration();

    @Test
    public void testGetUgi() throws IOException {
        this.conf.set("fs.default.name", "hdfs://localhost:4321/");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String user = "TheDoctor";
        Text userText = new Text(user);
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(userText, userText, null);
        Token token = new Token((TokenIdentifier)dtId, (SecretManager)new DummySecretManager(0L, 0L, 0L, 0L));
        String tokenString = token.encodeToUrlString();
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)tokenString);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)user);
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        InetSocketAddress serviceAddr = NameNode.getAddress((Configuration)this.conf);
        Text tokenService = SecurityUtil.buildTokenService((InetSocketAddress)serviceAddr);
        UserGroupInformation ugi = JspHelper.getUGI((HttpServletRequest)request, (Configuration)this.conf);
        Token tokenInUgi = (Token)ugi.getTokens().iterator().next();
        Assert.assertEquals((Object)tokenService, (Object)tokenInUgi.getService());
    }

    @Test
    public void testDelegationTokenUrlParam() {
        this.conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        String tokenString = "xyzabc";
        String delegationTokenParam = JspHelper.getDelegationTokenUrlParam((String)tokenString);
        Assert.assertEquals((Object)"&delegation=xyzabc", (Object)delegationTokenParam);
        this.conf.set("hadoop.security.authentication", "simple");
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        delegationTokenParam = JspHelper.getDelegationTokenUrlParam((String)tokenString);
        Assert.assertEquals((Object)"", (Object)delegationTokenParam);
    }

    public static class DummySecretManager
    extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
        public DummySecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        }

        public DelegationTokenIdentifier createIdentifier() {
            return null;
        }

        public byte[] createPassword(DelegationTokenIdentifier dtId) {
            return new byte[1];
        }
    }
}

