/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.balancer.Balancer;

public class TestBalancer
extends TestCase {
    private static final long CAPACITY = 500L;
    private static final String RACK0 = "/rack0";
    private static final String RACK1 = "/rack1";
    private static final String RACK2 = "/rack2";
    private static final String fileName = "/tmp.txt";
    private static final Path filePath = new Path("/tmp.txt");
    private MiniDFSCluster cluster;
    ClientProtocol client;
    static final int DEFAULT_BLOCK_SIZE = 10;
    private Balancer balancer;
    private Random r = new Random();

    private void initConf(Configuration conf) {
        conf.setLong("dfs.block.size", 10L);
        conf.setInt("io.bytes.per.checksum", 10);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setBoolean("dfs.datanode.simulateddatastorage", true);
        conf.setLong("dfs.balancer.movedWinWidth", 2000L);
    }

    private void createFile(long fileLen, short replicationFactor) throws IOException {
        FileSystem fs = this.cluster.getFileSystem();
        DFSTestUtil.createFile(fs, filePath, fileLen, replicationFactor, this.r.nextLong());
        DFSTestUtil.waitReplication(fs, filePath, replicationFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block[] generateBlocks(Configuration conf, long size, short numNodes) throws IOException {
        this.cluster = new MiniDFSCluster(conf, numNodes, true, null);
        try {
            this.cluster.waitActive();
            this.client = DFSClient.createNamenode((Configuration)conf);
            short replicationFactor = (short)(numNodes - 1);
            long fileLen = size / (long)replicationFactor;
            this.createFile(fileLen, replicationFactor);
            List locatedBlocks = this.client.getBlockLocations(fileName, 0L, fileLen).getLocatedBlocks();
            int numOfBlocks = locatedBlocks.size();
            Block[] blocks = new Block[numOfBlocks];
            for (int i = 0; i < numOfBlocks; ++i) {
                Block b = ((LocatedBlock)locatedBlocks.get(i)).getBlock();
                blocks[i] = new Block(b.getBlockId(), b.getNumBytes(), b.getGenerationStamp());
            }
            Block[] blockArray = blocks;
            return blockArray;
        }
        finally {
            this.cluster.shutdown();
        }
    }

    Block[][] distributeBlocks(Block[] blocks, short replicationFactor, long[] distribution) {
        int i;
        long[] usedSpace = new long[distribution.length];
        System.arraycopy(distribution, 0, usedSpace, 0, distribution.length);
        ArrayList blockReports = new ArrayList(usedSpace.length);
        Block[][] results = new Block[usedSpace.length][];
        for (i = 0; i < usedSpace.length; ++i) {
            blockReports.add(new ArrayList());
        }
        for (i = 0; i < blocks.length; ++i) {
            for (int j = 0; j < replicationFactor; ++j) {
                boolean notChosen = true;
                while (notChosen) {
                    int chosenIndex = this.r.nextInt(usedSpace.length);
                    if (usedSpace[chosenIndex] <= 0L) continue;
                    notChosen = false;
                    ((List)blockReports.get(chosenIndex)).add(blocks[i]);
                    int n = chosenIndex;
                    usedSpace[n] = usedSpace[n] - blocks[i].getNumBytes();
                }
            }
        }
        for (i = 0; i < usedSpace.length; ++i) {
            List nodeBlockList = (List)blockReports.get(i);
            results[i] = nodeBlockList.toArray(new Block[nodeBlockList.size()]);
        }
        return results;
    }

    private void testUnevenDistribution(Configuration conf, long[] distribution, long[] capacities, String[] racks) throws Exception {
        int numDatanodes = distribution.length;
        if (capacities.length != numDatanodes || racks.length != numDatanodes) {
            throw new IllegalArgumentException("Array length is not the same");
        }
        long totalUsedSpace = 0L;
        for (int i = 0; i < distribution.length; ++i) {
            totalUsedSpace += distribution[i];
        }
        Block[] blocks = this.generateBlocks(conf, totalUsedSpace, (short)numDatanodes);
        Block[][] blocksDN = this.distributeBlocks(blocks, (short)(numDatanodes - 1), distribution);
        conf.set("dfs.safemode.threshold.pct", "0.0f");
        this.cluster = new MiniDFSCluster(0, conf, numDatanodes, false, true, null, racks, capacities);
        this.cluster.waitActive();
        this.client = DFSClient.createNamenode((Configuration)conf);
        this.cluster.injectBlocks(blocksDN);
        long totalCapacity = 0L;
        for (long capacity : capacities) {
            totalCapacity += capacity;
        }
        this.runBalancer(conf, totalUsedSpace, totalCapacity);
    }

    private void waitForHeartBeat(long expectedUsedSpace, long expectedTotalSpace) throws IOException {
        long[] status = this.client.getStats();
        while (status[0] != expectedTotalSpace || status[1] != expectedUsedSpace) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            status = this.client.getStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(Configuration conf, long[] capacities, String[] racks, long newCapacity, String newRack) throws Exception {
        int numOfDatanodes = capacities.length;
        TestBalancer.assertEquals((int)numOfDatanodes, (int)racks.length);
        this.cluster = new MiniDFSCluster(0, conf, capacities.length, true, true, null, racks, capacities);
        try {
            this.cluster.waitActive();
            this.client = DFSClient.createNamenode((Configuration)conf);
            long totalCapacity = 0L;
            for (long capacity : capacities) {
                totalCapacity += capacity;
            }
            long totalUsedSpace = totalCapacity * 3L / 10L;
            this.createFile(totalUsedSpace / (long)numOfDatanodes, (short)numOfDatanodes);
            this.cluster.startDataNodes(conf, 1, true, null, new String[]{newRack}, new long[]{newCapacity});
            this.runBalancer(conf, totalUsedSpace, totalCapacity += newCapacity);
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private void runBalancer(Configuration conf, long totalUsedSpace, long totalCapacity) throws Exception {
        boolean balanced;
        this.waitForHeartBeat(totalUsedSpace, totalCapacity);
        this.balancer = new Balancer(conf);
        this.balancer.run(new String[0]);
        this.waitForHeartBeat(totalUsedSpace, totalCapacity);
        block2: do {
            DatanodeInfo[] datanodeReport = this.client.getDatanodeReport(FSConstants.DatanodeReportType.ALL);
            TestBalancer.assertEquals((int)datanodeReport.length, (int)this.cluster.getDataNodes().size());
            balanced = true;
            double avgUtilization = (double)totalUsedSpace / (double)totalCapacity * 100.0;
            for (DatanodeInfo datanode : datanodeReport) {
                if (!(Math.abs(avgUtilization - (double)datanode.getDfsUsed() / (double)datanode.getCapacity() * 100.0) > 10.0)) continue;
                balanced = false;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignored) {}
                continue block2;
            }
        } while (!balanced);
    }

    private void oneNodeTest(Configuration conf) throws Exception {
        this.test(conf, new long[]{500L}, new String[]{RACK0}, 250L, RACK0);
    }

    private void twoNodeTest(Configuration conf) throws Exception {
        this.test(conf, new long[]{500L, 500L}, new String[]{RACK0, RACK1}, 500L, RACK2);
    }

    public void integrationTest(Configuration conf) throws Exception {
        this.initConf(conf);
        this.oneNodeTest(conf);
    }

    public void testBalancer0() throws Exception {
        Configuration conf = new Configuration();
        this.initConf(conf);
        this.oneNodeTest(conf);
        this.twoNodeTest(conf);
    }

    public void testBalancer1() throws Exception {
        Configuration conf = new Configuration();
        this.initConf(conf);
        this.testUnevenDistribution(conf, new long[]{250L, 50L}, new long[]{500L, 500L}, new String[]{RACK0, RACK1});
    }

    public static void main(String[] args) throws Exception {
        TestBalancer balancerTest = new TestBalancer();
        balancerTest.testBalancer0();
        balancerTest.testBalancer1();
    }

    static {
        Balancer.setBlockMoveWaitTime((long)1000L);
    }
}

