/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDelegationToken {
    private static final Log LOG = LogFactory.getLog(TestDelegationToken.class);
    private MiniDFSCluster cluster;
    Configuration config;

    @Before
    public void setUp() throws Exception {
        this.config = new Configuration();
        this.config.setBoolean("dfs.webhdfs.enabled", true);
        this.config.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
        this.config.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
        this.config.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
        FileSystem.setDefaultUri((Configuration)this.config, (String)"hdfs://localhost:0");
        this.cluster = new MiniDFSCluster(0, this.config, 0, true, true, true, null, null, null, null);
        this.cluster.waitActive();
        this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager().startThreads();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private Token<DelegationTokenIdentifier> generateDelegationToken(String owner, String renewer) {
        DelegationTokenSecretManager dtSecretManager = this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager();
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(new Text(owner), new Text(renewer), null);
        return new Token((TokenIdentifier)dtId, (SecretManager)dtSecretManager);
    }

    @Test
    public void testDelegationTokenSecretManager() throws Exception {
        DelegationTokenSecretManager dtSecretManager = this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager();
        Token<DelegationTokenIdentifier> token = this.generateDelegationToken("SomeUser", "JobTracker");
        try {
            dtSecretManager.renewToken(token, "FakeRenewer");
            Assert.fail((String)"should have failed");
        }
        catch (AccessControlException ace) {
            // empty catch block
        }
        dtSecretManager.renewToken(token, "JobTracker");
        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
        byte[] tokenId = token.getIdentifier();
        identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        Assert.assertTrue((null != dtSecretManager.retrievePassword((AbstractDelegationTokenIdentifier)identifier) ? 1 : 0) != 0);
        LOG.info((Object)"Sleep to expire the token");
        Thread.sleep(6000L);
        try {
            dtSecretManager.retrievePassword((AbstractDelegationTokenIdentifier)identifier);
            Assert.fail((String)"Token should have expired");
        }
        catch (SecretManager.InvalidToken e) {
            // empty catch block
        }
        dtSecretManager.renewToken(token, "JobTracker");
        LOG.info((Object)"Sleep beyond the max lifetime");
        Thread.sleep(5000L);
        try {
            dtSecretManager.renewToken(token, "JobTracker");
            Assert.fail((String)"should have been expired");
        }
        catch (SecretManager.InvalidToken it) {
            // empty catch block
        }
    }

    @Test
    public void testCancelDelegationToken() throws Exception {
        DelegationTokenSecretManager dtSecretManager = this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager();
        Token<DelegationTokenIdentifier> token = this.generateDelegationToken("SomeUser", "JobTracker");
        try {
            dtSecretManager.cancelToken(token, "FakeCanceller");
            Assert.fail((String)"should have failed");
        }
        catch (AccessControlException ace) {
            // empty catch block
        }
        dtSecretManager.cancelToken(token, "JobTracker");
        try {
            dtSecretManager.renewToken(token, "JobTracker");
            Assert.fail((String)"should have failed");
        }
        catch (SecretManager.InvalidToken invalidToken) {
            // empty catch block
        }
    }

    @Test
    public void testDelegationTokenDFSApi() throws Exception {
        DelegationTokenSecretManager dtSecretManager = this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager();
        DistributedFileSystem dfs = (DistributedFileSystem)this.cluster.getFileSystem();
        final Token token = dfs.getDelegationToken(new Text("JobTracker"));
        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
        byte[] tokenId = token.getIdentifier();
        identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        LOG.info((Object)"A valid token should have non-null password, and should be renewed successfully");
        Assert.assertTrue((null != dtSecretManager.retrievePassword((AbstractDelegationTokenIdentifier)identifier) ? 1 : 0) != 0);
        dtSecretManager.renewToken(token, "JobTracker");
        UserGroupInformation.createRemoteUser((String)"JobTracker").doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                token.renew(TestDelegationToken.this.config);
                token.cancel(TestDelegationToken.this.config);
                return null;
            }
        });
    }

    @Test
    public void testDelegationTokenWebHdfsApi() throws Exception {
        ((Log4JLogger)NamenodeWebHdfsMethods.LOG).getLogger().setLevel(Level.ALL);
        DelegationTokenSecretManager dtSecretManager = this.cluster.getNameNode().getNamesystem().getDelegationTokenSecretManager();
        final String uri = "webhdfs://" + this.config.get("dfs.http.address");
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"JobTracker", (String[])new String[]{"user"});
        WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<WebHdfsFileSystem>(){

            @Override
            public WebHdfsFileSystem run() throws Exception {
                return (WebHdfsFileSystem)FileSystem.get((URI)new URI(uri), (Configuration)TestDelegationToken.this.config);
            }
        });
        final Token token = webhdfs.getDelegationToken("JobTracker");
        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
        byte[] tokenId = token.getIdentifier();
        identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        LOG.info((Object)"A valid token should have non-null password, and should be renewed successfully");
        Assert.assertTrue((null != dtSecretManager.retrievePassword((AbstractDelegationTokenIdentifier)identifier) ? 1 : 0) != 0);
        dtSecretManager.renewToken(token, "JobTracker");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                token.renew(TestDelegationToken.this.config);
                token.cancel(TestDelegationToken.this.config);
                return null;
            }
        });
    }

    @Test
    public void testDelegationTokenWithDoAs() throws Exception {
        DistributedFileSystem dfs = (DistributedFileSystem)this.cluster.getFileSystem();
        final Token token = dfs.getDelegationToken(new Text("JobTracker"));
        final UserGroupInformation longUgi = UserGroupInformation.createRemoteUser((String)"JobTracker/foo.com@FOO.COM");
        UserGroupInformation shortUgi = UserGroupInformation.createRemoteUser((String)"JobTracker");
        LOG.info((Object)("cluster at: " + dfs.getUri() + " token for: " + token.getService()));
        longUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                DistributedFileSystem dfs = (DistributedFileSystem)TestDelegationToken.this.cluster.getFileSystem();
                try {
                    dfs.renewDelegationToken(token);
                }
                catch (IOException e) {
                    LOG.error((Object)"caught unexpected exception out of renew", (Throwable)e);
                    Assert.fail((String)("Could not renew delegation token for user " + longUgi));
                }
                return null;
            }
        });
        shortUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                DistributedFileSystem dfs = (DistributedFileSystem)TestDelegationToken.this.cluster.getFileSystem();
                dfs.renewDelegationToken(token);
                return null;
            }
        });
        longUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                DistributedFileSystem dfs = (DistributedFileSystem)TestDelegationToken.this.cluster.getFileSystem();
                try {
                    dfs.cancelDelegationToken(token);
                }
                catch (IOException e) {
                    Assert.fail((String)("Could not cancel delegation token for user " + longUgi));
                }
                return null;
            }
        });
    }
}

