/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestRestartDFS
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTests(Configuration conf, boolean serviceTest) throws Exception {
        FileStatus dirstatus;
        FileStatus rootstatus;
        long rootmtime;
        FileSystem fs;
        MiniDFSCluster cluster = null;
        DFSTestUtil files = new DFSTestUtil("TestRestartDFS", 20, 3, 8192);
        String dir = "/srcdat";
        Path rootpath = new Path("/");
        Path dirpath = new Path("/srcdat");
        try {
            if (serviceTest) {
                conf.set("dfs.namenode.servicerpc-address", "localhost:0");
            }
            cluster = new MiniDFSCluster(conf, 4, true, null);
            fs = cluster.getFileSystem();
            files.createFiles(fs, "/srcdat");
            rootmtime = fs.getFileStatus(rootpath).getModificationTime();
            rootstatus = fs.getFileStatus(dirpath);
            dirstatus = fs.getFileStatus(dirpath);
            fs.setOwner(rootpath, rootstatus.getOwner() + "_XXX", null);
            fs.setOwner(dirpath, null, dirstatus.getGroup() + "_XXX");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        try {
            if (serviceTest) {
                conf.set("dfs.namenode.servicerpc-address", "localhost:0");
            }
            cluster = new MiniDFSCluster(conf, 4, false, null);
            fs = cluster.getFileSystem();
            TestRestartDFS.assertTrue((String)"Filesystem corrupted after restart.", (boolean)files.checkFiles(fs, "/srcdat"));
            FileStatus newrootstatus = fs.getFileStatus(rootpath);
            TestRestartDFS.assertEquals((long)rootmtime, (long)newrootstatus.getModificationTime());
            TestRestartDFS.assertEquals((String)(rootstatus.getOwner() + "_XXX"), (String)newrootstatus.getOwner());
            TestRestartDFS.assertEquals((String)rootstatus.getGroup(), (String)newrootstatus.getGroup());
            FileStatus newdirstatus = fs.getFileStatus(dirpath);
            TestRestartDFS.assertEquals((String)dirstatus.getOwner(), (String)newdirstatus.getOwner());
            TestRestartDFS.assertEquals((String)(dirstatus.getGroup() + "_XXX"), (String)newdirstatus.getGroup());
            files.cleanup(fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    public void testRestartDFS() throws Exception {
        Configuration conf = new Configuration();
        this.runTests(conf, false);
    }

    public void testRestartDualPortDFS() throws Exception {
        Configuration conf = new Configuration();
        this.runTests(conf, true);
    }
}

