/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;

public class TestInjectionForSimulatedStorage
extends TestCase {
    private int checksumSize = 16;
    private int blockSize = this.checksumSize * 2;
    private int numBlocks = 4;
    private int filesize = this.blockSize * this.numBlocks;
    private int numDataNodes = 4;
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestInjectionForSimulatedStorage");

    private void writeFile(FileSystem fileSys, Path name, int repl) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, (long)this.blockSize);
        byte[] buffer = new byte[this.filesize];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = 49;
        }
        stm.write(buffer);
        stm.close();
    }

    private void waitForBlockReplication(String filename, ClientProtocol namenode, int expected, long maxWaitSec) throws IOException {
        long start = System.currentTimeMillis();
        LOG.info((Object)("Checking for block replication for " + filename));
        LocatedBlocks blocks = namenode.getBlockLocations(filename, 0L, Long.MAX_VALUE);
        TestInjectionForSimulatedStorage.assertEquals((int)this.numBlocks, (int)blocks.locatedBlockCount());
        for (int i = 0; i < this.numBlocks; ++i) {
            int actual;
            LocatedBlock block;
            LOG.info((Object)("Checking for block:" + (i + 1)));
            while (true) {
                blocks = namenode.getBlockLocations(filename, 0L, Long.MAX_VALUE);
                TestInjectionForSimulatedStorage.assertEquals((int)this.numBlocks, (int)blocks.locatedBlockCount());
                block = blocks.get(i);
                actual = block.getLocations().length;
                if (actual == expected) break;
                LOG.info((Object)("Not enough replicas for " + (i + 1) + "th block " + block.getBlock() + " yet. Expecting " + expected + ", got " + actual + "."));
                if (maxWaitSec > 0L && System.currentTimeMillis() - start > maxWaitSec * 1000L) {
                    throw new IOException("Timedout while waiting for all blocks to  be replicated for " + filename);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignored) {}
            }
            LOG.info((Object)("Got enough replicas for " + (i + 1) + "th block " + block.getBlock() + ", got " + actual + "."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInjection() throws IOException {
        MiniDFSCluster cluster = null;
        String testFile = "/replication-test-file";
        Path testPath = new Path(testFile);
        byte[] buffer = new byte[1024];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = 49;
        }
        try {
            Configuration conf = new Configuration();
            conf.set("dfs.replication", Integer.toString(this.numDataNodes));
            conf.setInt("io.bytes.per.checksum", this.checksumSize);
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
            cluster = new MiniDFSCluster(0, conf, this.numDataNodes, true, true, null, null);
            cluster.waitActive();
            DFSClient dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), conf);
            this.writeFile(cluster.getFileSystem(), testPath, this.numDataNodes);
            this.waitForBlockReplication(testFile, dfsClient.namenode, this.numDataNodes, 20L);
            Block[][] blocksList = cluster.getAllBlockReports();
            cluster.shutdown();
            cluster = null;
            LOG.info((Object)"Restarting minicluster");
            conf = new Configuration();
            conf.setBoolean("dfs.datanode.simulateddatastorage", true);
            conf.set("dfs.safemode.threshold.pct", "0.0f");
            cluster = new MiniDFSCluster(0, conf, this.numDataNodes * 2, false, true, null, null);
            cluster.waitActive();
            HashSet<Block> uniqueBlocks = new HashSet<Block>();
            for (int i = 0; i < blocksList.length; ++i) {
                for (int j = 0; j < blocksList[i].length; ++j) {
                    uniqueBlocks.add(blocksList[i][j]);
                }
            }
            LOG.info((Object)("Inserting " + uniqueBlocks.size() + " blocks"));
            Block[] blocks = uniqueBlocks.toArray(new Block[uniqueBlocks.size()]);
            cluster.injectBlocks(0, blocks);
            dfsClient = new DFSClient(new InetSocketAddress("localhost", cluster.getNameNodePort()), conf);
            this.waitForBlockReplication(testFile, dfsClient.namenode, this.numDataNodes, -1L);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

