/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;

public class TestDFSFinalize
extends TestCase {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDFSFinalize");
    private Configuration conf;
    private int testCounter = 0;
    private MiniDFSCluster cluster = null;

    void log(String label, int numDirs) {
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST " + this.testCounter++ + "*** " + label + ":" + " numDirs=" + numDirs));
    }

    void checkResult(String[] nameNodeDirs, String[] dataNodeDirs) throws IOException {
        int i;
        for (i = 0; i < nameNodeDirs.length; ++i) {
            TestDFSFinalize.assertTrue((boolean)new File(nameNodeDirs[i], "current").isDirectory());
            TestDFSFinalize.assertTrue((boolean)new File(nameNodeDirs[i], "current/VERSION").isFile());
            TestDFSFinalize.assertTrue((boolean)new File(nameNodeDirs[i], "current/edits").isFile());
            TestDFSFinalize.assertTrue((boolean)new File(nameNodeDirs[i], "current/fsimage").isFile());
            TestDFSFinalize.assertTrue((boolean)new File(nameNodeDirs[i], "current/fstime").isFile());
        }
        for (i = 0; i < dataNodeDirs.length; ++i) {
            TestDFSFinalize.assertEquals((long)UpgradeUtilities.checksumContents(HdfsConstants.NodeType.DATA_NODE, new File(dataNodeDirs[i], "current")), (long)UpgradeUtilities.checksumMasterContents(HdfsConstants.NodeType.DATA_NODE));
        }
        for (i = 0; i < nameNodeDirs.length; ++i) {
            TestDFSFinalize.assertFalse((boolean)new File(nameNodeDirs[i], "previous").isDirectory());
        }
    }

    public void testFinalize() throws Exception {
        UpgradeUtilities.initialize();
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new Configuration();
            this.conf.setInt("dfs.datanode.scan.period.hours", -1);
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            String[] nameNodeDirs = this.conf.getStrings("dfs.name.dir");
            String[] dataNodeDirs = this.conf.getStrings("dfs.data.dir");
            this.log("Finalize with existing previous dir", numDirs);
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "current");
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.NAME_NODE, nameNodeDirs, "previous");
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs, "current");
            UpgradeUtilities.createStorageDirs(HdfsConstants.NodeType.DATA_NODE, dataNodeDirs, "previous");
            this.cluster = new MiniDFSCluster(this.conf, 1, HdfsConstants.StartupOption.REGULAR);
            this.cluster.finalizeCluster(this.conf);
            this.checkResult(nameNodeDirs, dataNodeDirs);
            this.log("Finalize without existing previous dir", numDirs);
            this.cluster.finalizeCluster(this.conf);
            this.checkResult(nameNodeDirs, dataNodeDirs);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
        }
    }

    protected void tearDown() throws Exception {
        LOG.info((Object)"Shutting down MiniDFSCluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDFSFinalize().testFinalize();
    }
}

