/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;

public class TestBalancerBandwidth
extends TestCase {
    private static final Configuration conf = new Configuration();
    private static final int NUM_OF_DATANODES = 2;
    private static final int DEFAULT_BANDWIDTH = 0x100000;
    public static final Log LOG = LogFactory.getLog(TestBalancerBandwidth.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBalancerBandwidth() throws Exception {
        conf.setLong("dfs.datanode.balance.bandwidthPerSec", 0x100000L);
        MiniDFSCluster cluster = new MiniDFSCluster(conf, 2, true, null);
        try {
            cluster.waitActive();
            DistributedFileSystem fs = (DistributedFileSystem)cluster.getFileSystem();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            TestBalancerBandwidth.assertEquals((long)0x100000L, (long)datanodes.get(0).getBalancerBandwidth());
            TestBalancerBandwidth.assertEquals((long)0x100000L, (long)datanodes.get(1).getBalancerBandwidth());
            long newBandwidth = 0xC00000L;
            fs.setBalancerBandwidth(newBandwidth);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            TestBalancerBandwidth.assertEquals((long)newBandwidth, (long)datanodes.get(0).getBalancerBandwidth());
            TestBalancerBandwidth.assertEquals((long)newBandwidth, (long)datanodes.get(1).getBalancerBandwidth());
            fs.setBalancerBandwidth(0L);
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            TestBalancerBandwidth.assertEquals((long)newBandwidth, (long)datanodes.get(0).getBalancerBandwidth());
            TestBalancerBandwidth.assertEquals((long)newBandwidth, (long)datanodes.get(1).getBalancerBandwidth());
        }
        finally {
            cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestBalancerBandwidth().testBalancerBandwidth();
    }
}

