/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.loadGenerator;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.loadGenerator.DataGenerator;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class LoadGenerator
extends Configured
implements Tool {
    private volatile boolean shouldRun = true;
    private Path root = DataGenerator.DEFAULT_ROOT;
    private FileSystem fs;
    private int maxDelayBetweenOps = 0;
    private int numOfThreads = 200;
    private double readPr = 0.3333;
    private double writePr = 0.3333;
    private long elapsedTime = 0L;
    private long startTime = System.currentTimeMillis() + 10000L;
    private static final int BLOCK_SIZE = 10;
    private ArrayList<String> files = new ArrayList();
    private ArrayList<String> dirs = new ArrayList();
    private Random r = null;
    private static final String USAGE = "java LoadGenerator\n-readProbability <read probability>\n-writeProbability <write probability>\n-root <root>\n-maxDelayBetweenOps <maxDelayBetweenOpsInMillis>\n-numOfThreads <numOfThreads>\n-elapsedTime <elapsedTimeInSecs>\n-startTime <startTimeInMillis>";
    private final String hostname;
    private static final int OPEN = 0;
    private static final int LIST = 1;
    private static final int CREATE = 2;
    private static final int WRITE_CLOSE = 3;
    private static final int DELETE = 4;
    private static final int TOTAL_OP_TYPES = 5;
    private long[] executionTime = new long[5];
    private long[] totalNumOfOps = new long[5];

    public LoadGenerator() throws IOException, UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        this.hostname = addr.getHostName();
    }

    public int run(String[] args) throws Exception {
        int exitCode = this.init(args);
        if (exitCode != 0) {
            return exitCode;
        }
        this.barrier();
        DFSClientThread[] threads = new DFSClientThread[this.numOfThreads];
        for (int i = 0; i < this.numOfThreads; ++i) {
            threads[i] = new DFSClientThread(i);
            threads[i].start();
        }
        if (this.elapsedTime > 0L) {
            Thread.sleep(this.elapsedTime * 1000L);
            this.shouldRun = false;
        }
        for (DFSClientThread thread : threads) {
            thread.join();
            for (int i = 0; i < 5; ++i) {
                int n = i;
                this.executionTime[n] = this.executionTime[n] + thread.executionTime[i];
                int n2 = i;
                this.totalNumOfOps[n2] = this.totalNumOfOps[n2] + thread.totalNumOfOps[i];
            }
        }
        long totalOps = 0L;
        for (int i = 0; i < 5; ++i) {
            totalOps += this.totalNumOfOps[i];
        }
        if (this.totalNumOfOps[0] != 0L) {
            System.out.println("Average open execution time: " + (double)this.executionTime[0] / (double)this.totalNumOfOps[0] + "ms");
        }
        if (this.totalNumOfOps[1] != 0L) {
            System.out.println("Average list execution time: " + (double)this.executionTime[1] / (double)this.totalNumOfOps[1] + "ms");
        }
        if (this.totalNumOfOps[4] != 0L) {
            System.out.println("Average deletion execution time: " + (double)this.executionTime[4] / (double)this.totalNumOfOps[4] + "ms");
            System.out.println("Average create execution time: " + (double)this.executionTime[2] / (double)this.totalNumOfOps[2] + "ms");
            System.out.println("Average write_close execution time: " + (double)this.executionTime[3] / (double)this.totalNumOfOps[3] + "ms");
        }
        if (this.elapsedTime != 0L) {
            System.out.println("Average operations per second: " + (double)totalOps / (double)this.elapsedTime + "ops/s");
        }
        System.out.println();
        return exitCode;
    }

    private int init(String[] args) throws IOException {
        try {
            this.fs = FileSystem.get((Configuration)this.getConf());
        }
        catch (IOException ioe) {
            System.err.println("Can not initialize the file system: " + ioe.getLocalizedMessage());
            return -1;
        }
        int hostHashCode = this.hostname.hashCode();
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-readProbability")) {
                    this.readPr = Double.parseDouble(args[++i]);
                    if (!(this.readPr < 0.0) && !(this.readPr > 1.0)) continue;
                    System.err.println("The read probability must be [0, 1]: " + this.readPr);
                    return -1;
                }
                if (args[i].equals("-writeProbability")) {
                    this.writePr = Double.parseDouble(args[++i]);
                    if (!(this.writePr < 0.0) && !(this.writePr > 1.0)) continue;
                    System.err.println("The write probability must be [0, 1]: " + this.writePr);
                    return -1;
                }
                if (args[i].equals("-root")) {
                    this.root = new Path(args[++i]);
                    continue;
                }
                if (args[i].equals("-maxDelayBetweenOps")) {
                    this.maxDelayBetweenOps = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-numOfThreads")) {
                    this.numOfThreads = Integer.parseInt(args[++i]);
                    if (this.numOfThreads > 0) continue;
                    System.err.println("Number of threads must be positive: " + this.numOfThreads);
                    return -1;
                }
                if (args[i].equals("-startTime")) {
                    this.startTime = Long.parseLong(args[++i]);
                    continue;
                }
                if (args[i].equals("-elapsedTime")) {
                    this.elapsedTime = Long.parseLong(args[++i]);
                    continue;
                }
                if (args[i].equals("-seed")) {
                    this.r = new Random(Long.parseLong(args[++i]) + (long)hostHashCode);
                    continue;
                }
                System.err.println(USAGE);
                ToolRunner.printGenericCommandUsage((PrintStream)System.err);
                return -1;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal parameter: " + e.getLocalizedMessage());
            System.err.println(USAGE);
            return -1;
        }
        if (this.readPr + this.writePr < 0.0 || this.readPr + this.writePr > 1.0) {
            System.err.println("The sum of read probability and write probability must be [0, 1]: " + this.readPr + " " + this.writePr);
            return -1;
        }
        if (this.r == null) {
            this.r = new Random(System.currentTimeMillis() + (long)hostHashCode);
        }
        return this.initFileDirTables();
    }

    private int initFileDirTables() {
        try {
            this.initFileDirTables(this.root);
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return -1;
        }
        if (this.dirs.isEmpty()) {
            System.err.println("The test space " + this.root + " is empty");
            return -1;
        }
        if (this.files.isEmpty()) {
            System.err.println("The test space " + this.root + " does not have any file");
            return -1;
        }
        return 0;
    }

    private void initFileDirTables(Path path) throws IOException {
        FileStatus[] stats = this.fs.listStatus(path);
        if (stats != null) {
            for (FileStatus stat : stats) {
                if (stat.isDir()) {
                    this.dirs.add(stat.getPath().toString());
                    this.initFileDirTables(stat.getPath());
                    continue;
                }
                Path filePath = stat.getPath();
                if (!filePath.getName().startsWith("_file_")) continue;
                this.files.add(filePath.toString());
            }
        }
    }

    private void barrier() {
        long sleepTime;
        while ((sleepTime = this.startTime - System.currentTimeMillis()) > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void genFile(Path file, long fileSize) throws IOException {
        long startTime = System.currentTimeMillis();
        FSDataOutputStream out = this.fs.create(file, true, this.getConf().getInt("io.file.buffer.size", 4096), (short)this.getConf().getInt("dfs.replication", 3), this.fs.getDefaultBlockSize());
        this.executionTime[2] = this.executionTime[2] + (System.currentTimeMillis() - startTime);
        this.totalNumOfOps[2] = this.totalNumOfOps[2] + 1L;
        for (long i = 0L; i < fileSize; ++i) {
            out.writeByte(97);
        }
        startTime = System.currentTimeMillis();
        out.close();
        this.executionTime[3] = this.executionTime[3] + (System.currentTimeMillis() - startTime);
        this.totalNumOfOps[3] = this.totalNumOfOps[3] + 1L;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new LoadGenerator(), (String[])args);
        System.exit(res);
    }

    private class DFSClientThread
    extends Thread {
        private int id;
        private long[] executionTime = new long[5];
        private long[] totalNumOfOps = new long[5];
        private byte[] buffer = new byte[1024];

        private DFSClientThread(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            try {
                while (LoadGenerator.this.shouldRun) {
                    this.nextOp();
                    this.delay();
                }
            }
            catch (Exception ioe) {
                System.err.println(ioe.getLocalizedMessage());
                ioe.printStackTrace();
            }
        }

        private void delay() throws InterruptedException {
            if (LoadGenerator.this.maxDelayBetweenOps > 0) {
                int delay = LoadGenerator.this.r.nextInt(LoadGenerator.this.maxDelayBetweenOps);
                Thread.sleep(delay);
            }
        }

        private void nextOp() throws IOException {
            double rn = LoadGenerator.this.r.nextDouble();
            if (rn < LoadGenerator.this.readPr) {
                this.read();
            } else if (rn < LoadGenerator.this.readPr + LoadGenerator.this.writePr) {
                this.write();
            } else {
                this.list();
            }
        }

        private void read() throws IOException {
            String fileName = (String)LoadGenerator.this.files.get(LoadGenerator.this.r.nextInt(LoadGenerator.this.files.size()));
            long startTime = System.currentTimeMillis();
            FSDataInputStream in = LoadGenerator.this.fs.open(new Path(fileName));
            this.executionTime[0] = this.executionTime[0] + (System.currentTimeMillis() - startTime);
            this.totalNumOfOps[0] = this.totalNumOfOps[0] + 1L;
            while (in.read(this.buffer) != -1) {
            }
            in.close();
        }

        private void write() throws IOException {
            double d;
            String dirName = (String)LoadGenerator.this.dirs.get(LoadGenerator.this.r.nextInt(LoadGenerator.this.dirs.size()));
            Path file = new Path(dirName, LoadGenerator.this.hostname + this.id);
            double fileSize = 0.0;
            do {
                fileSize = LoadGenerator.this.r.nextGaussian() + 2.0;
            } while (d <= 0.0);
            LoadGenerator.this.genFile(file, (long)(fileSize * 10.0));
            long startTime = System.currentTimeMillis();
            LoadGenerator.this.fs.delete(file, true);
            this.executionTime[4] = this.executionTime[4] + (System.currentTimeMillis() - startTime);
            this.totalNumOfOps[4] = this.totalNumOfOps[4] + 1L;
        }

        private void list() throws IOException {
            String dirName = (String)LoadGenerator.this.dirs.get(LoadGenerator.this.r.nextInt(LoadGenerator.this.dirs.size()));
            long startTime = System.currentTimeMillis();
            LoadGenerator.this.fs.listStatus(new Path(dirName));
            this.executionTime[1] = this.executionTime[1] + (System.currentTimeMillis() - startTime);
            this.totalNumOfOps[1] = this.totalNumOfOps[1] + 1L;
        }
    }
}

