/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.filecache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;

public class TestMRWithDistributedCache
extends TestCase {
    private static Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp"));
    private static Configuration conf = new Configuration();
    private static FileSystem localFs;
    private static final Log LOG;

    private void testWithConf(JobConf conf) throws IOException, InterruptedException, ClassNotFoundException, URISyntaxException {
        Path first = this.createTempFile("distributed.first", "x");
        Path second = this.makeJar(new Path(TEST_ROOT_DIR, "distributed.second.jar"), 2);
        Path third = this.makeJar(new Path(TEST_ROOT_DIR, "distributed.third.jar"), 3);
        Path fourth = this.makeJar(new Path(TEST_ROOT_DIR, "distributed.fourth.jar"), 4);
        DistributedCache.addCacheFile((URI)new URI(first.toUri().toString() + "#distributed.first.symlink"), (Configuration)conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        DistributedCache.addFileToClassPath((Path)second, (Configuration)conf, (FileSystem)fs);
        DistributedCache.addArchiveToClassPath((Path)third, (Configuration)conf, (FileSystem)fs);
        DistributedCache.addCacheArchive((URI)fourth.toUri(), (Configuration)conf);
        DistributedCache.createSymlink((Configuration)conf);
        conf.setMaxMapAttempts(1);
        Job job = new Job((Configuration)conf);
        job.setMapperClass(DistributedCacheChecker.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{first});
        job.submit();
        TestMRWithDistributedCache.assertTrue((boolean)job.waitForCompletion(false));
    }

    public void testLocalJobRunner() throws Exception {
        JobConf c = new JobConf();
        c.set("mapred.job.tracker", "local");
        c.set("fs.default.name", "file:///");
        this.testWithConf(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMiniMRJobRunner() throws Exception {
        MiniMRCluster m = new MiniMRCluster(1, "file:///", 1);
        try {
            this.testWithConf(m.createJobConf());
        }
        finally {
            m.shutdown();
        }
    }

    private Path createTempFile(String filename, String contents) throws IOException {
        Path path = new Path(TEST_ROOT_DIR, filename);
        FSDataOutputStream os = localFs.create(path);
        os.writeBytes(contents);
        os.close();
        return path;
    }

    private Path makeJar(Path p, int index) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(new File(p.toString()));
        JarOutputStream jos = new JarOutputStream(fos);
        ZipEntry ze = new ZipEntry("distributed.jar.inside" + index);
        jos.putNextEntry(ze);
        jos.write(("inside the jar!" + index).getBytes());
        jos.closeEntry();
        jos.close();
        return p;
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        LOG = LogFactory.getLog(TestMRWithDistributedCache.class);
    }

    public static class DistributedCacheChecker
    extends Mapper<LongWritable, Text, NullWritable, NullWritable> {
        public void setup(Mapper.Context context) throws IOException {
            Configuration conf = context.getConfiguration();
            Path[] files = DistributedCache.getLocalCacheFiles((Configuration)conf);
            Path[] archives = DistributedCache.getLocalCacheArchives((Configuration)conf);
            FileSystem fs = LocalFileSystem.get((Configuration)conf);
            TestCase.assertEquals((int)2, (int)files.length);
            TestCase.assertEquals((int)2, (int)archives.length);
            TestCase.assertEquals((long)1L, (long)fs.getFileStatus(files[0]).getLen());
            TestCase.assertTrue((fs.getFileStatus(files[1]).getLen() > 1L ? 1 : 0) != 0);
            TestCase.assertTrue((boolean)fs.exists(new Path(archives[0], "distributed.jar.inside3")));
            TestCase.assertTrue((boolean)fs.exists(new Path(archives[1], "distributed.jar.inside4")));
            LOG.info((Object)("Java Classpath: " + System.getProperty("java.class.path")));
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            TestCase.assertNotNull((Object)cl.getResource("distributed.jar.inside2"));
            TestCase.assertNotNull((Object)cl.getResource("distributed.jar.inside3"));
            TestCase.assertNull((Object)cl.getResource("distributed.jar.inside4"));
            if (!"local".equals(context.getConfiguration().get("mapred.job.tracker"))) {
                File symlinkFile = new File("distributed.first.symlink");
                TestCase.assertTrue((boolean)symlinkFile.exists());
                TestCase.assertEquals((long)1L, (long)symlinkFile.length());
            }
        }
    }
}

