/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.hadoop.cli.TestCLI;
import org.apache.hadoop.cli.util.CLITestData;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.mapred.tools.MRAdmin;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CommandExecutor {
    private static String commandOutput = null;
    private static int exitCode = 0;
    private static Exception lastException = null;
    private static String cmdExecuted = null;

    private static String[] getCommandAsArgs(String cmd, String masterKey, String master) {
        StringTokenizer tokenizer = new StringTokenizer(cmd, " ");
        String[] args = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            args[i] = tokenizer.nextToken();
            args[i] = args[i].replaceAll(masterKey, master);
            args[i] = args[i].replaceAll("CLITEST_DATA", new File(TestCLI.TEST_CACHE_DATA_DIR).toURI().toString().replace(' ', '+'));
            args[i] = args[i].replaceAll("USERNAME", System.getProperty("user.name"));
            ++i;
        }
        return args;
    }

    public static int executeCommand(CLITestData.TestCmd cmd, String namenode, String jobtracker) throws Exception {
        switch (cmd.getType()) {
            case DFSADMIN: {
                return CommandExecutor.executeDFSAdminCommand(cmd.getCmd(), namenode);
            }
            case MRADMIN: {
                return CommandExecutor.executeMRAdminCommand(cmd.getCmd(), jobtracker);
            }
            case FS: {
                return CommandExecutor.executeFSCommand(cmd.getCmd(), namenode);
            }
        }
        throw new Exception("Unknow type of Test command:" + (Object)((Object)cmd.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeDFSAdminCommand(String cmd, String namenode) {
        exitCode = 0;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        System.setOut(new PrintStream(bao));
        System.setErr(new PrintStream(bao));
        DFSAdmin shell = new DFSAdmin();
        String[] args = CommandExecutor.getCommandAsArgs(cmd, "NAMENODE", namenode);
        cmdExecuted = cmd;
        try {
            ToolRunner.run((Tool)shell, (String[])args);
        }
        catch (Exception e) {
            e.printStackTrace();
            lastException = e;
            exitCode = -1;
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
        }
        commandOutput = bao.toString();
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeMRAdminCommand(String cmd, String jobtracker) {
        exitCode = 0;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        System.setOut(new PrintStream(bao));
        System.setErr(new PrintStream(bao));
        MRAdmin mradmin = new MRAdmin();
        String[] args = CommandExecutor.getCommandAsArgs(cmd, "JOBTRACKER", jobtracker);
        cmdExecuted = cmd;
        try {
            ToolRunner.run((Tool)mradmin, (String[])args);
        }
        catch (Exception e) {
            e.printStackTrace();
            lastException = e;
            exitCode = -1;
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
        }
        commandOutput = bao.toString();
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeFSCommand(String cmd, String namenode) {
        exitCode = 0;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        System.setOut(new PrintStream(bao));
        System.setErr(new PrintStream(bao));
        FsShell shell = new FsShell();
        String[] args = CommandExecutor.getCommandAsArgs(cmd, "NAMENODE", namenode);
        cmdExecuted = cmd;
        try {
            ToolRunner.run((Tool)shell, (String[])args);
        }
        catch (Exception e) {
            e.printStackTrace();
            lastException = e;
            exitCode = -1;
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
        }
        commandOutput = bao.toString();
        return exitCode;
    }

    public static String getLastCommandOutput() {
        return commandOutput;
    }

    public static int getLastExitCode() {
        return exitCode;
    }

    public static Exception getLastException() {
        return lastException;
    }

    public static String getLastCommand() {
        return cmdExecuted;
    }
}

