/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;

@InterfaceAudience.Private
public interface INodeFileAttributes
extends INodeAttributes {
    public short getFileReplication();

    public long getPreferredBlockSize();

    public long getHeaderLong();

    public static class SnapshotCopy
    extends INodeAttributes.SnapshotCopy
    implements INodeFileAttributes {
        private final long header;

        public SnapshotCopy(byte[] name, PermissionStatus permissions, AclFeature aclFeature, long modificationTime, long accessTime, short replication, long preferredBlockSize) {
            super(name, permissions, aclFeature, modificationTime, accessTime);
            long h = INodeFile.HeaderFormat.combineReplication(0L, replication);
            this.header = INodeFile.HeaderFormat.combinePreferredBlockSize(h, preferredBlockSize);
        }

        public SnapshotCopy(INodeFile file) {
            super(file);
            this.header = file.getHeaderLong();
        }

        @Override
        public short getFileReplication() {
            return INodeFile.HeaderFormat.getReplication(this.header);
        }

        @Override
        public long getPreferredBlockSize() {
            return INodeFile.HeaderFormat.getPreferredBlockSize(this.header);
        }

        @Override
        public long getHeaderLong() {
            return this.header;
        }
    }
}

