/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.WritableUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSImageSerialization {
    private static final ThreadLocal<TLData> TL_DATA = new ThreadLocal<TLData>(){

        @Override
        protected TLData initialValue() {
            return new TLData();
        }
    };

    private FSImageSerialization() {
    }

    static INodeFile readINodeUnderConstruction(DataInput in, FSNamesystem fsNamesys, int imgVersion) throws IOException {
        byte[] name = FSImageSerialization.readBytes(in);
        long inodeId = NameNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion) ? in.readLong() : fsNamesys.allocateNewInodeId();
        short blockReplication = in.readShort();
        long modificationTime = in.readLong();
        long preferredBlockSize = in.readLong();
        int numBlocks = in.readInt();
        BlockInfo[] blocks = new BlockInfo[numBlocks];
        Block blk = new Block();
        for (int i = 0; i < numBlocks - 1; ++i) {
            blk.readFields(in);
            blocks[i] = new BlockInfo(blk, blockReplication);
        }
        if (numBlocks > 0) {
            blk.readFields(in);
            blocks[i] = new BlockInfoUnderConstruction(blk, blockReplication, HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        }
        PermissionStatus perm = PermissionStatus.read((DataInput)in);
        String clientName = FSImageSerialization.readString(in);
        String clientMachine = FSImageSerialization.readString(in);
        int numLocs = in.readInt();
        assert (numLocs == 0) : "Unexpected block locations";
        INodeFile file = new INodeFile(inodeId, name, perm, modificationTime, modificationTime, blocks, blockReplication, preferredBlockSize);
        file.toUnderConstruction(clientName, clientMachine, null);
        return file;
    }

    public static String readString(DataInput in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return ustr.toStringChecked();
    }

    static String readString_EmptyAsNull(DataInput in) throws IOException {
        String s = FSImageSerialization.readString(in);
        return s.isEmpty() ? null : s;
    }

    public static void writeString(String str, DataOutput out) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.set(str);
        ustr.write(out);
    }

    static long readLong(DataInput in) throws IOException {
        LongWritable uLong = FSImageSerialization.TL_DATA.get().U_LONG;
        uLong.readFields(in);
        return uLong.get();
    }

    static void writeLong(long value, DataOutputStream out) throws IOException {
        LongWritable uLong = FSImageSerialization.TL_DATA.get().U_LONG;
        uLong.set(value);
        uLong.write((DataOutput)out);
    }

    static int readInt(DataInput in) throws IOException {
        IntWritable uInt = FSImageSerialization.TL_DATA.get().U_INT;
        uInt.readFields(in);
        return uInt.get();
    }

    static void writeInt(int value, DataOutputStream out) throws IOException {
        IntWritable uInt = FSImageSerialization.TL_DATA.get().U_INT;
        uInt.set(value);
        uInt.write((DataOutput)out);
    }

    static short readShort(DataInput in) throws IOException {
        ShortWritable uShort = FSImageSerialization.TL_DATA.get().U_SHORT;
        uShort.readFields(in);
        return uShort.get();
    }

    static void writeShort(short value, DataOutputStream out) throws IOException {
        ShortWritable uShort = FSImageSerialization.TL_DATA.get().U_SHORT;
        uShort.set(value);
        uShort.write((DataOutput)out);
    }

    public static byte[] readBytes(DataInput in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        int len = ustr.getLength();
        byte[] bytes = new byte[len];
        System.arraycopy(ustr.getBytes(), 0, bytes, 0, len);
        return bytes;
    }

    public static byte[][] readPathComponents(DataInput in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return DFSUtil.bytes2byteArray(ustr.getBytes(), ustr.getLength(), (byte)47);
    }

    public static byte[] readLocalName(DataInput in) throws IOException {
        byte[] createdNodeName = new byte[in.readShort()];
        in.readFully(createdNodeName);
        return createdNodeName;
    }

    public static void writeBytes(byte[] data, DataOutput out) throws IOException {
        out.writeShort(data.length);
        out.write(data);
    }

    public static void writeCompactBlockArray(Block[] blocks, DataOutputStream out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)blocks.length);
        Block prev = null;
        for (Block b : blocks) {
            long szDelta = b.getNumBytes() - (prev != null ? prev.getNumBytes() : 0L);
            long gsDelta = b.getGenerationStamp() - (prev != null ? prev.getGenerationStamp() : 0L);
            out.writeLong(b.getBlockId());
            WritableUtils.writeVLong((DataOutput)out, (long)szDelta);
            WritableUtils.writeVLong((DataOutput)out, (long)gsDelta);
            prev = b;
        }
    }

    public static Block[] readCompactBlockArray(DataInput in, int logVersion) throws IOException {
        int num = WritableUtils.readVInt((DataInput)in);
        if (num < 0) {
            throw new IOException("Invalid block array length: " + num);
        }
        Block prev = null;
        Block[] ret = new Block[num];
        for (int i = 0; i < num; ++i) {
            long id = in.readLong();
            long sz = WritableUtils.readVLong((DataInput)in) + (prev != null ? prev.getNumBytes() : 0L);
            long gs = WritableUtils.readVLong((DataInput)in) + (prev != null ? prev.getGenerationStamp() : 0L);
            ret[i] = new Block(id, sz, gs);
            prev = ret[i];
        }
        return ret;
    }

    public static void writeCacheDirectiveInfo(DataOutputStream out, CacheDirectiveInfo directive) throws IOException {
        FSImageSerialization.writeLong(directive.getId(), out);
        int flags = (directive.getPath() != null ? 1 : 0) | (directive.getReplication() != null ? 2 : 0) | (directive.getPool() != null ? 4 : 0) | (directive.getExpiration() != null ? 8 : 0);
        out.writeInt(flags);
        if (directive.getPath() != null) {
            FSImageSerialization.writeString(directive.getPath().toUri().getPath(), out);
        }
        if (directive.getReplication() != null) {
            FSImageSerialization.writeShort(directive.getReplication(), out);
        }
        if (directive.getPool() != null) {
            FSImageSerialization.writeString(directive.getPool(), out);
        }
        if (directive.getExpiration() != null) {
            FSImageSerialization.writeLong(directive.getExpiration().getMillis(), out);
        }
    }

    public static CacheDirectiveInfo readCacheDirectiveInfo(DataInput in) throws IOException {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder();
        builder.setId(FSImageSerialization.readLong(in));
        int flags = in.readInt();
        if ((flags & 1) != 0) {
            builder.setPath(new Path(FSImageSerialization.readString(in)));
        }
        if ((flags & 2) != 0) {
            builder.setReplication(FSImageSerialization.readShort(in));
        }
        if ((flags & 4) != 0) {
            builder.setPool(FSImageSerialization.readString(in));
        }
        if ((flags & 8) != 0) {
            builder.setExpiration(CacheDirectiveInfo.Expiration.newAbsolute(FSImageSerialization.readLong(in)));
        }
        if ((flags & 0xFFFFFFF0) != 0) {
            throw new IOException("unknown flags set in ModifyCacheDirectiveInfoOp: " + flags);
        }
        return builder.build();
    }

    public static CacheDirectiveInfo readCacheDirectiveInfo(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        String expiryTime;
        String pool;
        String replicationString;
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder();
        builder.setId(Long.parseLong(st.getValue("ID")));
        String path = st.getValueOrNull("PATH");
        if (path != null) {
            builder.setPath(new Path(path));
        }
        if ((replicationString = st.getValueOrNull("REPLICATION")) != null) {
            builder.setReplication(Short.parseShort(replicationString));
        }
        if ((pool = st.getValueOrNull("POOL")) != null) {
            builder.setPool(pool);
        }
        if ((expiryTime = st.getValueOrNull("EXPIRATION")) != null) {
            builder.setExpiration(CacheDirectiveInfo.Expiration.newAbsolute(Long.parseLong(expiryTime)));
        }
        return builder.build();
    }

    public static void writeCacheDirectiveInfo(ContentHandler contentHandler, CacheDirectiveInfo directive) throws SAXException {
        XMLUtils.addSaxString(contentHandler, "ID", Long.toString(directive.getId()));
        if (directive.getPath() != null) {
            XMLUtils.addSaxString(contentHandler, "PATH", directive.getPath().toUri().getPath());
        }
        if (directive.getReplication() != null) {
            XMLUtils.addSaxString(contentHandler, "REPLICATION", Short.toString(directive.getReplication()));
        }
        if (directive.getPool() != null) {
            XMLUtils.addSaxString(contentHandler, "POOL", directive.getPool());
        }
        if (directive.getExpiration() != null) {
            XMLUtils.addSaxString(contentHandler, "EXPIRATION", "" + directive.getExpiration().getMillis());
        }
    }

    public static void writeCachePoolInfo(DataOutputStream out, CachePoolInfo info) throws IOException {
        FSImageSerialization.writeString(info.getPoolName(), out);
        String ownerName = info.getOwnerName();
        String groupName = info.getGroupName();
        Long limit = info.getLimit();
        FsPermission mode = info.getMode();
        Long maxRelativeExpiry = info.getMaxRelativeExpiryMs();
        boolean hasOwner = ownerName != null;
        boolean hasGroup = groupName != null;
        boolean hasMode = mode != null;
        boolean hasLimit = limit != null;
        boolean hasMaxRelativeExpiry = maxRelativeExpiry != null;
        int flags = (hasOwner ? 1 : 0) | (hasGroup ? 2 : 0) | (hasMode ? 4 : 0) | (hasLimit ? 8 : 0) | (hasMaxRelativeExpiry ? 16 : 0);
        FSImageSerialization.writeInt(flags, out);
        if (hasOwner) {
            FSImageSerialization.writeString(ownerName, out);
        }
        if (hasGroup) {
            FSImageSerialization.writeString(groupName, out);
        }
        if (hasMode) {
            mode.write((DataOutput)out);
        }
        if (hasLimit) {
            FSImageSerialization.writeLong(limit, out);
        }
        if (hasMaxRelativeExpiry) {
            FSImageSerialization.writeLong(maxRelativeExpiry, out);
        }
    }

    public static CachePoolInfo readCachePoolInfo(DataInput in) throws IOException {
        String poolName = FSImageSerialization.readString(in);
        CachePoolInfo info = new CachePoolInfo(poolName);
        int flags = FSImageSerialization.readInt(in);
        if ((flags & 1) != 0) {
            info.setOwnerName(FSImageSerialization.readString(in));
        }
        if ((flags & 2) != 0) {
            info.setGroupName(FSImageSerialization.readString(in));
        }
        if ((flags & 4) != 0) {
            info.setMode(FsPermission.read((DataInput)in));
        }
        if ((flags & 8) != 0) {
            info.setLimit(FSImageSerialization.readLong(in));
        }
        if ((flags & 0x10) != 0) {
            info.setMaxRelativeExpiryMs(FSImageSerialization.readLong(in));
        }
        if ((flags & 0xFFFFFFE0) != 0) {
            throw new IOException("Unknown flag in CachePoolInfo: " + flags);
        }
        return info;
    }

    public static void writeCachePoolInfo(ContentHandler contentHandler, CachePoolInfo info) throws SAXException {
        XMLUtils.addSaxString(contentHandler, "POOLNAME", info.getPoolName());
        String ownerName = info.getOwnerName();
        String groupName = info.getGroupName();
        Long limit = info.getLimit();
        FsPermission mode = info.getMode();
        Long maxRelativeExpiry = info.getMaxRelativeExpiryMs();
        if (ownerName != null) {
            XMLUtils.addSaxString(contentHandler, "OWNERNAME", ownerName);
        }
        if (groupName != null) {
            XMLUtils.addSaxString(contentHandler, "GROUPNAME", groupName);
        }
        if (mode != null) {
            FSEditLogOp.fsPermissionToXml(contentHandler, mode);
        }
        if (limit != null) {
            XMLUtils.addSaxString(contentHandler, "LIMIT", Long.toString(limit));
        }
        if (maxRelativeExpiry != null) {
            XMLUtils.addSaxString(contentHandler, "MAXRELATIVEEXPIRY", Long.toString(maxRelativeExpiry));
        }
    }

    public static CachePoolInfo readCachePoolInfo(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
        String poolName = st.getValue("POOLNAME");
        CachePoolInfo info = new CachePoolInfo(poolName);
        if (st.hasChildren("OWNERNAME")) {
            info.setOwnerName(st.getValue("OWNERNAME"));
        }
        if (st.hasChildren("GROUPNAME")) {
            info.setGroupName(st.getValue("GROUPNAME"));
        }
        if (st.hasChildren("MODE")) {
            info.setMode(FSEditLogOp.fsPermissionFromXml(st));
        }
        if (st.hasChildren("LIMIT")) {
            info.setLimit(Long.parseLong(st.getValue("LIMIT")));
        }
        if (st.hasChildren("MAXRELATIVEEXPIRY")) {
            info.setMaxRelativeExpiryMs(Long.parseLong(st.getValue("MAXRELATIVEEXPIRY")));
        }
        return info;
    }

    private static final class TLData {
        final DeprecatedUTF8 U_STR = new DeprecatedUTF8();
        final ShortWritable U_SHORT = new ShortWritable();
        final IntWritable U_INT = new IntWritable();
        final LongWritable U_LONG = new LongWritable();

        private TLData() {
        }
    }
}

