/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config.xstream;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Method;

public class QNameConverter
implements Converter {
    private static final String QNAME_CLASS = "javax.xml.namespace.QName";

    public boolean canConvert(Class clazz) {
        return QNAME_CLASS.equals(clazz.getName());
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext marshallingContext) {
        writer.setValue(object.toString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext unmarshallingContext) {
        Class qnameClass = unmarshallingContext.getRequiredType();
        if (!this.canConvert(qnameClass)) {
            throw new ConversionException("Unexpected type in unmarshal: " + qnameClass.getName());
        }
        String qnameString = reader.getValue();
        try {
            Method method = qnameClass.getMethod("valueOf", String.class);
            Object qname = method.invoke(null, qnameString);
            return qname;
        }
        catch (Exception e) {
            throw new ConversionException("Unable to convert value to a qname: " + qnameString, e);
        }
    }
}

