/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.util.Collection;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.KernelConfigurationManager;
import org.apache.geronimo.kernel.config.ManageableAttributeStore;
import org.apache.geronimo.kernel.config.PersistentConfigurationList;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;

public class EditableKernelConfigurationManager
extends KernelConfigurationManager
implements EditableConfigurationManager {
    public static final GBeanInfo GBEAN_INFO;

    public EditableKernelConfigurationManager(Kernel kernel, Collection stores, ManageableAttributeStore attributeStore, PersistentConfigurationList configurationList, ArtifactManager artifactManager, ArtifactResolver artifactResolver, Collection repositories, Collection watchers, ClassLoader classLoader) {
        super(kernel, stores, attributeStore, configurationList, artifactManager, artifactResolver, repositories, watchers, classLoader);
    }

    public void addGBeanToConfiguration(Artifact configurationId, GBeanData gbean, boolean start) throws InvalidConfigException {
        Configuration configuration = this.getConfiguration(configurationId);
        try {
            configuration.addGBean(gbean);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new InvalidConfigException("Cound not add GBean " + gbean.getAbstractName() + " to configuration " + configurationId, e);
        }
        this.addGBeanToConfiguration(configuration, gbean, start);
    }

    public void addGBeanToConfiguration(Artifact configurationId, String name, GBeanData gbean, boolean start) throws InvalidConfigException {
        Configuration configuration = this.getConfiguration(configurationId);
        try {
            configuration.addGBean(name, gbean);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new InvalidConfigException("Cound not add GBean " + gbean.getAbstractName() + " to configuration " + configurationId, e);
        }
        this.addGBeanToConfiguration(configuration, gbean, start);
    }

    private void addGBeanToConfiguration(Configuration configuration, GBeanData gbean, boolean start) throws InvalidConfigException {
        ClassLoader configurationClassLoader;
        block15: {
            configurationClassLoader = configuration.getConfigurationClassLoader();
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(configurationClassLoader);
                log.trace((Object)("Registering GBean " + gbean.getAbstractName()));
                ConfigurationUtil.preprocessGBeanData(configuration.getAbstractName(), configuration, gbean);
                this.kernel.loadGBean(gbean, configurationClassLoader);
                if (!start) break block15;
                try {
                    this.kernel.startRecursiveGBean(gbean.getAbstractName());
                }
                catch (GBeanNotFoundException e) {
                    throw new InvalidConfigException("How could we not find a GBean that we just loaded ('" + gbean.getAbstractName() + "')?", e);
                }
            }
            catch (Exception e) {
                try {
                    configuration.removeGBean(gbean.getAbstractName());
                }
                catch (GBeanNotFoundException e1) {
                    // empty catch block
                }
                try {
                    this.kernel.stopGBean(gbean.getAbstractName());
                }
                catch (GBeanNotFoundException e1) {
                    // empty catch block
                }
                try {
                    this.kernel.unloadGBean(gbean.getAbstractName());
                }
                catch (GBeanNotFoundException e1) {
                    // empty catch block
                }
                if (e instanceof InvalidConfigException) {
                    throw (InvalidConfigException)e;
                }
                throw new InvalidConfigException("Cound not add GBean " + gbean.getAbstractName() + " to configuration " + configuration.getId(), e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        if (this.attributeStore != null) {
            this.attributeStore.addGBean(configuration.getId(), gbean, configurationClassLoader);
        }
    }

    public void removeGBeanFromConfiguration(Artifact configurationId, AbstractName gbeanName) throws GBeanNotFoundException, InvalidConfigException {
        Configuration configuration = this.getConfiguration(configurationId);
        if (!configuration.containsGBean(gbeanName)) {
            throw new GBeanNotFoundException(gbeanName);
        }
        configuration.removeGBean(gbeanName);
        try {
            if (this.kernel.getGBeanState(gbeanName) == 1) {
                this.kernel.stopGBean(gbeanName);
            }
            this.kernel.unloadGBean(gbeanName);
        }
        catch (GBeanNotFoundException e) {
            // empty catch block
        }
        if (this.attributeStore != null) {
            this.attributeStore.setShouldLoad(configurationId, gbeanName, false);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(EditableKernelConfigurationManager.class, KernelConfigurationManager.GBEAN_INFO, "ConfigurationManager");
        infoFactory.addInterface(EditableConfigurationManager.class);
        infoFactory.setConstructor(new String[]{"kernel", "Stores", "AttributeStore", "PersistentConfigurationList", "ArtifactManager", "ArtifactResolver", "Repositories", "Watchers", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

