/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protostuff;

import io.protostuff.GraphIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.protostuff.Wrapper;
import org.apache.dubbo.common.serialize.protostuff.utils.WrapperUtils;

public class ProtostuffObjectInput
implements ObjectInput {
    private DataInputStream dis;

    public ProtostuffObjectInput(InputStream inputStream) {
        this.dis = new DataInputStream(inputStream);
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        Object result;
        int classNameLength = this.dis.readInt();
        int bytesLength = this.dis.readInt();
        if (classNameLength < 0 || bytesLength < 0) {
            throw new IOException();
        }
        byte[] classNameBytes = new byte[classNameLength];
        this.dis.readFully(classNameBytes, 0, classNameLength);
        byte[] bytes = new byte[bytesLength];
        this.dis.readFully(bytes, 0, bytesLength);
        String className = new String(classNameBytes);
        Class<?> clazz = Class.forName(className);
        if (WrapperUtils.needWrapper(clazz)) {
            Schema schema = RuntimeSchema.getSchema(Wrapper.class);
            Wrapper wrapper = (Wrapper)schema.newMessage();
            GraphIOUtil.mergeFrom((byte[])bytes, (Object)wrapper, (Schema)schema);
            result = wrapper.getData();
        } else {
            Schema schema = RuntimeSchema.getSchema(clazz);
            result = schema.newMessage();
            GraphIOUtil.mergeFrom((byte[])bytes, (Object)result, (Schema)schema);
        }
        return result;
    }

    public <T> T readObject(Class<T> clazz) throws IOException, ClassNotFoundException {
        return (T)this.readObject();
    }

    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        return this.readObject(cls);
    }

    public boolean readBool() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public String readUTF() throws IOException {
        int length = this.dis.readInt();
        byte[] bytes = new byte[length];
        this.dis.read(bytes, 0, length);
        return new String(bytes);
    }

    public byte[] readBytes() throws IOException {
        int length = this.dis.readInt();
        byte[] bytes = new byte[length];
        this.dis.read(bytes, 0, length);
        return bytes;
    }
}

