/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.spring.context.event.ServiceBeanExportedEvent;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.apache.dubbo.config.spring.util.BeanFactoryUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ServiceBean<T>
extends ServiceConfig<T>
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
BeanNameAware,
ApplicationEventPublisherAware {
    private static final long serialVersionUID = 213195494150089726L;
    private final transient Service service;
    private transient ApplicationContext applicationContext;
    private transient String beanName;
    private transient boolean supportedApplicationListener;
    private ApplicationEventPublisher applicationEventPublisher;

    public ServiceBean() {
        this.service = null;
    }

    public ServiceBean(Service service) {
        super(service);
        this.service = service;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
        this.supportedApplicationListener = BeanFactoryUtils.addApplicationListener(applicationContext, this);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public Service getService() {
        return this.service;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.isExported() && !this.isUnexported()) {
            if (logger.isInfoEnabled()) {
                logger.info("The service ready on spring started. service: " + this.getInterface());
            }
            this.export();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getProvider() == null) {
            Map providerConfigMap;
            Map map = providerConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ProviderConfig.class, (boolean)false, (boolean)false);
            if (providerConfigMap != null && providerConfigMap.size() > 0) {
                Map protocolConfigMap;
                Map map2 = protocolConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ProtocolConfig.class, (boolean)false, (boolean)false);
                if (CollectionUtils.isEmptyMap(protocolConfigMap) && providerConfigMap.size() > 1) {
                    ArrayList<ProviderConfig> providerConfigs = new ArrayList<ProviderConfig>();
                    for (ProviderConfig config : providerConfigMap.values()) {
                        if (config.isDefault() == null || !config.isDefault().booleanValue()) continue;
                        providerConfigs.add(config);
                    }
                    if (!providerConfigs.isEmpty()) {
                        this.setProviders(providerConfigs);
                    }
                } else {
                    ProviderConfig providerConfig = null;
                    for (ProviderConfig config : providerConfigMap.values()) {
                        if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                        if (providerConfig != null) {
                            throw new IllegalStateException("Duplicate provider configs: " + providerConfig + " and " + config);
                        }
                        providerConfig = config;
                    }
                    if (providerConfig != null) {
                        this.setProvider(providerConfig);
                    }
                }
            }
        }
        if (this.getApplication() == null && (this.getProvider() == null || this.getProvider().getApplication() == null)) {
            Map applicationConfigMap;
            Map map = applicationConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ApplicationConfig.class, (boolean)false, (boolean)false);
            if (applicationConfigMap != null && applicationConfigMap.size() > 0) {
                ApplicationConfig applicationConfig = null;
                for (ApplicationConfig config : applicationConfigMap.values()) {
                    if (applicationConfig != null) {
                        throw new IllegalStateException("Duplicate application configs: " + applicationConfig + " and " + config);
                    }
                    applicationConfig = config;
                }
                if (applicationConfig != null) {
                    this.setApplication(applicationConfig);
                }
            }
        }
        if (this.getModule() == null && (this.getProvider() == null || this.getProvider().getModule() == null)) {
            Map moduleConfigMap;
            Map map = moduleConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ModuleConfig.class, (boolean)false, (boolean)false);
            if (moduleConfigMap != null && moduleConfigMap.size() > 0) {
                ApplicationConfig moduleConfig = null;
                for (ApplicationConfig config : moduleConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (moduleConfig != null) {
                        throw new IllegalStateException("Duplicate module configs: " + moduleConfig + " and " + config);
                    }
                    moduleConfig = config;
                }
                if (moduleConfig != null) {
                    this.setModule((ModuleConfig)moduleConfig);
                }
            }
        }
        if (StringUtils.isEmpty((String)this.getRegistryIds())) {
            if (this.getApplication() != null && StringUtils.isNotEmpty((String)this.getApplication().getRegistryIds())) {
                this.setRegistryIds(this.getApplication().getRegistryIds());
            }
            if (this.getProvider() != null && StringUtils.isNotEmpty((String)this.getProvider().getRegistryIds())) {
                this.setRegistryIds(this.getProvider().getRegistryIds());
            }
        }
        if (CollectionUtils.isEmpty((Collection)this.getRegistries()) && (this.getProvider() == null || CollectionUtils.isEmpty((Collection)this.getProvider().getRegistries())) && (this.getApplication() == null || CollectionUtils.isEmpty((Collection)this.getApplication().getRegistries()))) {
            Map registryConfigMap;
            Map map = registryConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, RegistryConfig.class, (boolean)false, (boolean)false);
            if (CollectionUtils.isNotEmptyMap(registryConfigMap)) {
                ArrayList<ApplicationConfig> registryConfigs = new ArrayList<ApplicationConfig>();
                if (StringUtils.isNotEmpty((String)this.registryIds)) {
                    Arrays.stream(CommonConstants.COMMA_SPLIT_PATTERN.split(this.registryIds)).forEach(id -> {
                        if (registryConfigMap.containsKey(id)) {
                            registryConfigs.add((ApplicationConfig)registryConfigMap.get(id));
                        }
                    });
                }
                if (registryConfigs.isEmpty()) {
                    for (ApplicationConfig config : registryConfigMap.values()) {
                        if (!StringUtils.isEmpty((String)this.registryIds)) continue;
                        registryConfigs.add(config);
                    }
                }
                if (!registryConfigs.isEmpty()) {
                    super.setRegistries(registryConfigs);
                }
            }
        }
        if (this.getMetadataReportConfig() == null) {
            Map metadataReportConfigMap;
            Map map = metadataReportConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MetadataReportConfig.class, (boolean)false, (boolean)false);
            if (metadataReportConfigMap != null && metadataReportConfigMap.size() == 1) {
                super.setMetadataReportConfig((MetadataReportConfig)metadataReportConfigMap.values().iterator().next());
            } else if (metadataReportConfigMap != null && metadataReportConfigMap.size() > 1) {
                throw new IllegalStateException("Multiple MetadataReport configs: " + metadataReportConfigMap);
            }
        }
        if (this.getConfigCenter() == null) {
            Map configenterMap;
            Map map = configenterMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ConfigCenterConfig.class, (boolean)false, (boolean)false);
            if (configenterMap != null && configenterMap.size() == 1) {
                super.setConfigCenter((ConfigCenterConfig)configenterMap.values().iterator().next());
            } else if (configenterMap != null && configenterMap.size() > 1) {
                throw new IllegalStateException("Multiple ConfigCenter found:" + configenterMap);
            }
        }
        if (!(this.getMonitor() != null || this.getProvider() != null && this.getProvider().getMonitor() != null || this.getApplication() != null && this.getApplication().getMonitor() != null)) {
            Map monitorConfigMap;
            Map map = monitorConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MonitorConfig.class, (boolean)false, (boolean)false);
            if (monitorConfigMap != null && monitorConfigMap.size() > 0) {
                ApplicationConfig monitorConfig = null;
                for (ApplicationConfig config : monitorConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (monitorConfig != null) {
                        throw new IllegalStateException("Duplicate monitor configs: " + monitorConfig + " and " + config);
                    }
                    monitorConfig = config;
                }
                if (monitorConfig != null) {
                    this.setMonitor((MonitorConfig)monitorConfig);
                }
            }
        }
        if (this.getMetrics() == null) {
            Map metricsConfigMap;
            Map map = metricsConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MetricsConfig.class, (boolean)false, (boolean)false);
            if (metricsConfigMap != null && metricsConfigMap.size() > 0) {
                ApplicationConfig metricsConfig = null;
                for (ApplicationConfig config : metricsConfigMap.values()) {
                    if (metricsConfig != null) {
                        throw new IllegalStateException("Duplicate metrics configs: " + metricsConfig + " and " + config);
                    }
                    metricsConfig = config;
                }
                if (metricsConfig != null) {
                    this.setMetrics((MetricsConfig)metricsConfig);
                }
            }
        }
        if (StringUtils.isEmpty((String)this.getProtocolIds()) && this.getProvider() != null && StringUtils.isNotEmpty((String)this.getProvider().getProtocolIds())) {
            this.setProtocolIds(this.getProvider().getProtocolIds());
        }
        if (CollectionUtils.isEmpty((Collection)this.getProtocols()) && (this.getProvider() == null || CollectionUtils.isEmpty((Collection)this.getProvider().getProtocols()))) {
            Map protocolConfigMap;
            Map map = protocolConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ProtocolConfig.class, (boolean)false, (boolean)false);
            if (protocolConfigMap != null && protocolConfigMap.size() > 0) {
                ArrayList<ApplicationConfig> protocolConfigs = new ArrayList<ApplicationConfig>();
                if (StringUtils.isNotEmpty((String)this.getProtocolIds())) {
                    Arrays.stream(CommonConstants.COMMA_SPLIT_PATTERN.split(this.getProtocolIds())).forEach(id -> {
                        if (protocolConfigMap.containsKey(id)) {
                            protocolConfigs.add((ApplicationConfig)protocolConfigMap.get(id));
                        }
                    });
                }
                if (protocolConfigs.isEmpty()) {
                    for (ApplicationConfig config : protocolConfigMap.values()) {
                        if (!StringUtils.isEmpty((String)this.protocolIds)) continue;
                        protocolConfigs.add(config);
                    }
                }
                if (!protocolConfigs.isEmpty()) {
                    super.setProtocols(protocolConfigs);
                }
            }
        }
        if (StringUtils.isEmpty((String)this.getPath()) && StringUtils.isNotEmpty((String)this.beanName) && StringUtils.isNotEmpty((String)this.getInterface()) && this.beanName.startsWith(this.getInterface())) {
            this.setPath(this.beanName);
        }
        if (!this.supportedApplicationListener) {
            this.export();
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void export() {
        super.export();
        this.publishExportEvent();
    }

    private void publishExportEvent() {
        ServiceBeanExportedEvent exportEvent = new ServiceBeanExportedEvent(this);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)exportEvent);
    }

    public void destroy() throws Exception {
    }

    protected Class getServiceClass(T ref) {
        if (AopUtils.isAopProxy(ref)) {
            return AopUtils.getTargetClass(ref);
        }
        return super.getServiceClass(ref);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

