/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.ConfigCenterBean;
import org.apache.dubbo.config.spring.extension.SpringExtensionFactory;
import org.apache.dubbo.config.support.Parameter;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReferenceBean<T>
extends ReferenceConfig<T>
implements FactoryBean,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final long serialVersionUID = 213195494150089726L;
    private transient ApplicationContext applicationContext;

    public ReferenceBean() {
    }

    public ReferenceBean(Reference reference) {
        super(reference);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
    }

    public Object getObject() {
        return this.get();
    }

    public Class<?> getObjectType() {
        return this.getInterfaceClass();
    }

    @Parameter(excluded=true)
    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.applicationContext != null) {
            BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ConfigCenterBean.class, (boolean)false, (boolean)false);
        }
        if (this.getConsumer() == null) {
            Map consumerConfigMap;
            Map map = consumerConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ConsumerConfig.class, (boolean)false, (boolean)false);
            if (consumerConfigMap != null && consumerConfigMap.size() > 0) {
                ConsumerConfig consumerConfig = null;
                for (ConsumerConfig config : consumerConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (consumerConfig != null) {
                        throw new IllegalStateException("Duplicate consumer configs: " + consumerConfig + " and " + config);
                    }
                    consumerConfig = config;
                }
                if (consumerConfig != null) {
                    this.setConsumer(consumerConfig);
                }
            }
        }
        if (this.getApplication() == null && (this.getConsumer() == null || this.getConsumer().getApplication() == null)) {
            Map applicationConfigMap;
            Map map = applicationConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ApplicationConfig.class, (boolean)false, (boolean)false);
            if (applicationConfigMap != null && applicationConfigMap.size() > 0) {
                ConsumerConfig applicationConfig = null;
                for (ConsumerConfig config : applicationConfigMap.values()) {
                    if (applicationConfig != null) {
                        throw new IllegalStateException("Duplicate application configs: " + applicationConfig + " and " + config);
                    }
                    applicationConfig = config;
                }
                if (applicationConfig != null) {
                    this.setApplication((ApplicationConfig)applicationConfig);
                }
            }
        }
        if (this.getModule() == null && (this.getConsumer() == null || this.getConsumer().getModule() == null)) {
            Map moduleConfigMap;
            Map map = moduleConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ModuleConfig.class, (boolean)false, (boolean)false);
            if (moduleConfigMap != null && moduleConfigMap.size() > 0) {
                ConsumerConfig moduleConfig = null;
                for (ConsumerConfig config : moduleConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (moduleConfig != null) {
                        throw new IllegalStateException("Duplicate module configs: " + moduleConfig + " and " + config);
                    }
                    moduleConfig = config;
                }
                if (moduleConfig != null) {
                    this.setModule((ModuleConfig)moduleConfig);
                }
            }
        }
        if (StringUtils.isEmpty((String)this.getRegistryIds())) {
            if (this.getApplication() != null && StringUtils.isNotEmpty((String)this.getApplication().getRegistryIds())) {
                this.setRegistryIds(this.getApplication().getRegistryIds());
            }
            if (this.getConsumer() != null && StringUtils.isNotEmpty((String)this.getConsumer().getRegistryIds())) {
                this.setRegistryIds(this.getConsumer().getRegistryIds());
            }
        }
        if (CollectionUtils.isEmpty((Collection)this.getRegistries()) && (this.getConsumer() == null || CollectionUtils.isEmpty((Collection)this.getConsumer().getRegistries())) && (this.getApplication() == null || CollectionUtils.isEmpty((Collection)this.getApplication().getRegistries()))) {
            Map registryConfigMap;
            Map map = registryConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, RegistryConfig.class, (boolean)false, (boolean)false);
            if (registryConfigMap != null && registryConfigMap.size() > 0) {
                ArrayList<ConsumerConfig> registryConfigs = new ArrayList<ConsumerConfig>();
                if (StringUtils.isNotEmpty((String)this.registryIds)) {
                    Arrays.stream(CommonConstants.COMMA_SPLIT_PATTERN.split(this.registryIds)).forEach(id -> {
                        if (registryConfigMap.containsKey(id)) {
                            registryConfigs.add((ConsumerConfig)registryConfigMap.get(id));
                        }
                    });
                }
                if (registryConfigs.isEmpty()) {
                    for (ConsumerConfig config : registryConfigMap.values()) {
                        if (!StringUtils.isEmpty((String)this.registryIds)) continue;
                        registryConfigs.add(config);
                    }
                }
                if (!registryConfigs.isEmpty()) {
                    super.setRegistries(registryConfigs);
                }
            }
        }
        if (this.getMetadataReportConfig() == null) {
            Map metadataReportConfigMap;
            Map map = metadataReportConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MetadataReportConfig.class, (boolean)false, (boolean)false);
            if (metadataReportConfigMap != null && metadataReportConfigMap.size() == 1) {
                super.setMetadataReportConfig((MetadataReportConfig)metadataReportConfigMap.values().iterator().next());
            } else if (metadataReportConfigMap != null && metadataReportConfigMap.size() > 1) {
                throw new IllegalStateException("Multiple MetadataReport configs: " + metadataReportConfigMap);
            }
        }
        if (this.getConfigCenter() == null) {
            Map configenterMap;
            Map map = configenterMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ConfigCenterConfig.class, (boolean)false, (boolean)false);
            if (configenterMap != null && configenterMap.size() == 1) {
                super.setConfigCenter((ConfigCenterConfig)configenterMap.values().iterator().next());
            } else if (configenterMap != null && configenterMap.size() > 1) {
                throw new IllegalStateException("Multiple ConfigCenter found:" + configenterMap);
            }
        }
        if (!(this.getMonitor() != null || this.getConsumer() != null && this.getConsumer().getMonitor() != null || this.getApplication() != null && this.getApplication().getMonitor() != null)) {
            Map monitorConfigMap;
            Map map = monitorConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MonitorConfig.class, (boolean)false, (boolean)false);
            if (monitorConfigMap != null && monitorConfigMap.size() > 0) {
                ConsumerConfig monitorConfig = null;
                for (ConsumerConfig config : monitorConfigMap.values()) {
                    if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                    if (monitorConfig != null) {
                        throw new IllegalStateException("Duplicate monitor configs: " + monitorConfig + " and " + config);
                    }
                    monitorConfig = config;
                }
                if (monitorConfig != null) {
                    this.setMonitor((MonitorConfig)monitorConfig);
                }
            }
        }
        if (this.getMetrics() == null) {
            Map metricsConfigMap;
            Map map = metricsConfigMap = this.applicationContext == null ? null : BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MetricsConfig.class, (boolean)false, (boolean)false);
            if (metricsConfigMap != null && metricsConfigMap.size() > 0) {
                ConsumerConfig metricsConfig = null;
                for (ConsumerConfig config : metricsConfigMap.values()) {
                    if (metricsConfig != null) {
                        throw new IllegalStateException("Duplicate metrics configs: " + metricsConfig + " and " + config);
                    }
                    metricsConfig = config;
                }
                if (metricsConfig != null) {
                    this.setMetrics((MetricsConfig)metricsConfig);
                }
            }
        }
        if (this.shouldInit()) {
            this.getObject();
        }
    }

    public void destroy() {
    }
}

