/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.GrantAndDenial;
import org.apache.directory.shared.ldap.aci.ItemPermission;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemFirstACIItem
extends ACIItem {
    private final Collection<ProtectedItem> protectedItems;
    private final Collection<ItemPermission> itemPermissions;

    public ItemFirstACIItem(String identificationTag, int precedence, AuthenticationLevel authenticationLevel, Collection<ProtectedItem> protectedItems, Collection<ItemPermission> itemPermissions) {
        super(identificationTag, precedence, authenticationLevel);
        this.protectedItems = Collections.unmodifiableCollection(new ArrayList<ProtectedItem>(protectedItems));
        this.itemPermissions = Collections.unmodifiableCollection(new ArrayList<ItemPermission>(itemPermissions));
    }

    public Collection<ProtectedItem> getProtectedItems() {
        return this.protectedItems;
    }

    public Collection<ItemPermission> getItemPermissions() {
        return this.itemPermissions;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append(super.toString());
        buf.append(", itemOrUserFirst itemFirst: { ");
        buf.append("protectedItems { ");
        boolean isFirst = true;
        for (ProtectedItem item : this.protectedItems) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(item.toString());
        }
        buf.append(" }, itemPermissions { ");
        isFirst = true;
        for (ItemPermission permission : this.itemPermissions) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(permission.toString());
        }
        buf.append(" } } }");
        return buf.toString();
    }

    @Override
    public Collection<ACITuple> toTuples() {
        ArrayList<ACITuple> tuples = new ArrayList<ACITuple>();
        for (ItemPermission itemPermission : this.itemPermissions) {
            int precedence;
            Set<GrantAndDenial> grants = itemPermission.getGrants();
            Set<GrantAndDenial> denials = itemPermission.getDenials();
            int n = precedence = itemPermission.getPrecedence() != null ? itemPermission.getPrecedence().intValue() : this.getPrecedence();
            if (grants.size() > 0) {
                tuples.add(new ACITuple(itemPermission.getUserClasses(), this.getAuthenticationLevel(), this.protectedItems, ItemFirstACIItem.toMicroOperations(grants), true, precedence));
            }
            if (denials.size() <= 0) continue;
            tuples.add(new ACITuple(itemPermission.getUserClasses(), this.getAuthenticationLevel(), this.protectedItems, ItemFirstACIItem.toMicroOperations(denials), false, precedence));
        }
        return tuples;
    }
}

