/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolableLdapConnectionFactory
implements PoolableObjectFactory {
    private LdapConnectionConfig config;
    private static final Logger LOG = LoggerFactory.getLogger(PoolableLdapConnectionFactory.class);

    public PoolableLdapConnectionFactory(LdapConnectionConfig config) {
        this.config = config;
    }

    public void activateObject(Object obj) throws Exception {
        LOG.debug("activating {}", obj);
    }

    public void destroyObject(Object obj) throws Exception {
        LOG.debug("destroying {}", obj);
        LdapConnection connection = (LdapConnection)obj;
        connection.unBind();
        connection.close();
    }

    public Object makeObject() throws Exception {
        LOG.debug("creating a LDAP connection");
        LdapNetworkConnection connection = new LdapNetworkConnection(this.config);
        connection.bind(this.config.getName(), this.config.getCredentials());
        return connection;
    }

    public void passivateObject(Object obj) throws Exception {
        LOG.debug("passivating {}", obj);
    }

    public boolean validateObject(Object obj) {
        LOG.debug("validating {}", obj);
        LdapConnection connection = (LdapConnection)obj;
        return connection.isConnected();
    }
}

