/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import java.util.Iterator;
import java.util.List;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.AbstractRequestDsml;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ModifyRequestDsml
extends AbstractRequestDsml {
    public ModifyRequestDsml() {
        super((LdapMessageCodec)new ModifyRequestCodec());
    }

    public ModifyRequestDsml(ModifyRequestCodec ldapMessage) {
        super((LdapMessageCodec)ldapMessage);
    }

    public MessageTypeEnum getMessageType() {
        return this.instance.getMessageType();
    }

    public Element toDsml(Element root) {
        Element element = super.toDsml(root);
        ModifyRequestCodec request = (ModifyRequestCodec)this.instance;
        if (request.getObject() != null) {
            element.addAttribute("dn", request.getObject().getName());
        }
        List modifications = request.getModifications();
        for (int i = 0; i < modifications.size(); ++i) {
            ModificationOperation operation;
            Modification modificationItem = (Modification)modifications.get(i);
            Element modElement = element.addElement("modification");
            if (modificationItem.getAttribute() != null) {
                modElement.addAttribute("name", modificationItem.getAttribute().getId());
                Iterator iterator = modificationItem.getAttribute().getAll();
                while (iterator.hasNext()) {
                    Value value = (Value)iterator.next();
                    if (value.get() == null) continue;
                    if (ParserUtils.needsBase64Encoding(value.get())) {
                        Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                        element.getDocument().getRootElement().add(xsdNamespace);
                        element.getDocument().getRootElement().add(xsiNamespace);
                        Element valueElement = modElement.addElement("value").addText(ParserUtils.base64Encode(value.get()));
                        valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                        continue;
                    }
                    modElement.addElement("value").setText(value.getString());
                }
            }
            if ((operation = modificationItem.getOperation()) == ModificationOperation.ADD_ATTRIBUTE) {
                modElement.addAttribute("operation", "add");
                continue;
            }
            if (operation == ModificationOperation.REPLACE_ATTRIBUTE) {
                modElement.addAttribute("operation", "replace");
                continue;
            }
            if (operation != ModificationOperation.REMOVE_ATTRIBUTE) continue;
            modElement.addAttribute("operation", "delete");
        }
        return element;
    }
}

