/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.directory.shared.dsmlv2.Dsmlv2Container;
import org.apache.directory.shared.dsmlv2.GrammarTransition;
import org.apache.directory.shared.dsmlv2.Tag;
import org.apache.directory.shared.dsmlv2.request.BatchRequest;
import org.apache.directory.shared.dsmlv2.request.Dsmlv2Grammar;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class Dsmlv2Parser {
    private Dsmlv2Container container = new Dsmlv2Container();

    public Dsmlv2Parser() throws XmlPullParserException {
        this.container.setGrammar(Dsmlv2Grammar.getInstance());
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        this.container.setParser(xpp);
    }

    public void setInputFile(String fileName) throws FileNotFoundException, XmlPullParserException {
        FileReader reader = new FileReader(fileName);
        this.container.getParser().setInput((Reader)reader);
    }

    public void setInput(InputStream inputStream, String inputEncoding) throws XmlPullParserException {
        this.container.getParser().setInput(inputStream, inputEncoding);
    }

    public void setInput(String str) throws XmlPullParserException {
        this.container.getParser().setInput((Reader)new StringReader(str));
    }

    public void parse() throws XmlPullParserException, IOException {
        Dsmlv2Grammar grammar = Dsmlv2Grammar.getInstance();
        grammar.executeAction(this.container);
    }

    public void parseBatchRequest() throws XmlPullParserException {
        XmlPullParser xpp = this.container.getParser();
        int eventType = xpp.getEventType();
        do {
            if (eventType == 0) {
                this.container.setState(0);
            } else if (eventType == 1) {
                this.container.setState(-1);
            } else if (eventType == 2) {
                this.processTag(this.container, Tag.START);
            } else if (eventType == 3) {
                this.processTag(this.container, Tag.END);
            }
            try {
                eventType = xpp.next();
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03037", (Object[])new Object[]{e.getLocalizedMessage()}), xpp, null);
            }
        } while (this.container.getState() != 104);
    }

    private void processTag(Dsmlv2Container container, int tagType) throws XmlPullParserException {
        XmlPullParser xpp = container.getParser();
        String tagName = xpp.getName().toLowerCase();
        GrammarTransition transition = container.getTransition(container.getState(), new Tag(tagName, tagType));
        if (transition != null) {
            container.setState(transition.getNextState());
            if (transition.hasAction()) {
                transition.getAction().action(container);
            }
        } else {
            throw new XmlPullParserException(I18n.err((String)"ERR_03036", (Object[])new Object[]{new Tag(tagName, tagType)}), xpp, null);
        }
    }

    public BatchRequest getBatchRequest() {
        return this.container.getBatchRequest();
    }

    public LdapMessageCodec getNextRequest() throws XmlPullParserException {
        if (this.container.getBatchRequest() == null) {
            this.parseBatchRequest();
        }
        XmlPullParser xpp = this.container.getParser();
        int eventType = xpp.getEventType();
        while (true) {
            if (eventType == 4) {
                try {
                    xpp.next();
                }
                catch (IOException e) {
                    throw new XmlPullParserException(I18n.err((String)"ERR_03037", (Object[])new Object[]{e.getLocalizedMessage()}), xpp, null);
                }
                eventType = xpp.getEventType();
                continue;
            }
            if (eventType == 0) {
                this.container.setState(0);
            } else {
                if (eventType == 1) {
                    this.container.setState(-1);
                    return null;
                }
                if (eventType == 2) {
                    this.processTag(this.container, Tag.START);
                } else if (eventType == 3) {
                    this.processTag(this.container, Tag.END);
                }
            }
            try {
                eventType = xpp.next();
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03037", (Object[])new Object[]{e.getLocalizedMessage()}), xpp, null);
            }
            if (this.container.getState() == 105) break;
        }
        return this.container.getBatchRequest().getCurrentRequest();
    }

    public void parseAllRequests() throws XmlPullParserException {
        while (this.getNextRequest() != null) {
        }
    }
}

