/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.util.Iterator;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.CursorIterator;

public abstract class AbstractIndexCursor<V, Entry, ID>
extends AbstractCursor<IndexEntry<V, ID>>
implements IndexCursor<V, Entry, ID> {
    private boolean available = false;
    protected static final String UNSUPPORTED_MSG = "Unsupported operation";

    public boolean available() {
        return this.available;
    }

    protected abstract String getUnsupportedMessage();

    public void after(IndexEntry<V, ID> element) throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    public void before(IndexEntry<V, ID> element) throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    @Override
    public void afterValue(ID id, V value) throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    @Override
    public void beforeValue(ID id, V value) throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    protected boolean setAvailable(boolean available) {
        this.available = available;
        return this.available;
    }

    public Iterator<IndexEntry<V, ID>> iterator() {
        return new CursorIterator((Cursor)this);
    }

    public boolean isAfterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isAfterLast()")}));
    }

    public boolean isBeforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isBeforeFirst()")}));
    }

    public boolean isFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isFirst()")}));
    }

    public boolean isLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_02014_UNSUPPORTED_OPERATION, (Object[])new Object[]{this.getClass().getName().concat(".").concat("isLast()")}));
    }
}

