/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared.transport;

import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.mina.core.service.IoAcceptor;

public abstract class AbstractTransport
implements Transport {
    private String address;
    private int port = -1;
    private boolean sslEnabled = false;
    private int nbThreads;
    private int backlog;
    protected IoAcceptor acceptor;
    protected static final int DEFAULT_BACKLOG_NB = 50;
    protected static final String LOCAL_HOST = "localhost";
    protected static final int DEFAULT_NB_THREADS = 3;

    public AbstractTransport() {
        this.address = null;
        this.nbThreads = 3;
        this.port = -1;
        this.backlog = 50;
    }

    public AbstractTransport(int port) {
        this.address = LOCAL_HOST;
        this.port = port;
    }

    public AbstractTransport(int port, int nbThreads) {
        this.address = LOCAL_HOST;
        this.port = port;
        this.nbThreads = nbThreads;
    }

    public AbstractTransport(String address, int port) {
        this.address = address;
        this.port = port;
    }

    public AbstractTransport(int port, int nbThreads, int backLog) {
        this.address = "localHost";
        this.port = port;
        this.nbThreads = nbThreads;
        this.backlog = backLog;
    }

    public AbstractTransport(String address, int port, int nbThreads, int backLog) {
        this.address = address;
        this.port = port;
        this.nbThreads = nbThreads;
        this.backlog = backLog;
    }

    public abstract void init();

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public abstract IoAcceptor getAcceptor();

    public int getNbThreads() {
        return this.nbThreads;
    }

    public void setNbThreads(int nbThreads) {
        this.nbThreads = nbThreads;
    }

    public int getBackLog() {
        return this.backlog;
    }

    public void setBackLog(int backLog) {
        this.backlog = backLog;
    }

    public void setEnableSSL(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void enableSSL(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    public boolean getEnableSSL() {
        return this.sslEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[<").append(this.address).append(':').append(this.port);
        sb.append(">], backlog=").append(this.backlog);
        sb.append(", nbThreads = ").append(this.nbThreads);
        if (this.sslEnabled) {
            sb.append(", SSL");
        }
        sb.append(']');
        return sb.toString();
    }
}

