/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.wss4j.AbstractTokenInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JTokenConverter;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.cache.ReplayCache;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.processor.UsernameTokenProcessor;
import org.apache.ws.security.validate.Validator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UsernameTokenInterceptor
extends AbstractTokenInterceptor {
    @Override
    protected void processToken(SoapMessage message) {
        Header h = this.findSecurityHeader(message, false);
        if (h == null) {
            return;
        }
        boolean utWithCallbacks = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.validate.token", (boolean)true);
        Element el = (Element)h.getObject();
        Element child = DOMUtils.getFirstElement((Node)el);
        while (child != null) {
            if ("UsernameToken".equals(child.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) {
                try {
                    Object principal = null;
                    Subject subject = null;
                    if (utWithCallbacks) {
                        WSSecurityEngineResult result = this.validateToken(child, message);
                        principal = (Principal)result.get((Object)"principal");
                        subject = (Subject)result.get((Object)"subject");
                    } else {
                        boolean bspCompliant = this.isWsiBSPCompliant(message);
                        principal = this.parseTokenAndCreatePrincipal(child, bspCompliant);
                        WSS4JTokenConverter.convertToken((Message)message, (Principal)principal);
                    }
                    SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
                    if (sc == null || sc.getUserPrincipal() == null) {
                        if (subject != null && principal != null) {
                            message.put(SecurityContext.class, (Object)this.createSecurityContext((Principal)principal, subject));
                        } else if (principal instanceof WSUsernameTokenPrincipal) {
                            Object utPrincipal = principal;
                            subject = this.createSubject(utPrincipal.getName(), utPrincipal.getPassword(), utPrincipal.isPasswordDigest(), utPrincipal.getNonce(), utPrincipal.getCreatedTime());
                            message.put(SecurityContext.class, (Object)this.createSecurityContext((Principal)utPrincipal, subject));
                        }
                    }
                    if (principal instanceof WSUsernameTokenPrincipal) {
                        this.storeResults((WSUsernameTokenPrincipal)principal, message);
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault((Throwable)ex);
                }
            }
            child = DOMUtils.getNextElement((Element)child);
        }
    }

    private void storeResults(WSUsernameTokenPrincipal principal, SoapMessage message) {
        ArrayList<WSSecurityEngineResult> v = new ArrayList<WSSecurityEngineResult>();
        int action = 1;
        if (principal.getPassword() == null) {
            action = 8192;
        }
        v.add(0, new WSSecurityEngineResult(action, (Principal)principal, null, null, null));
        ArrayList<WSHandlerResult> results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
        if (results == null) {
            results = new ArrayList<WSHandlerResult>();
            message.put("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult(null, v);
        results.add(0, rResult);
        this.assertTokens(message, principal, false);
        message.put("wss4j.principal.result", (Object)principal);
    }

    @Deprecated
    protected WSUsernameTokenPrincipal getPrincipal(Element tokenElement, SoapMessage message) throws WSSecurityException {
        return null;
    }

    protected WSSecurityEngineResult validateToken(Element tokenElement, final SoapMessage message) throws WSSecurityException {
        UsernameTokenProcessor p = new UsernameTokenProcessor();
        WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
        RequestData data = new RequestData(){

            public CallbackHandler getCallbackHandler() {
                return UsernameTokenInterceptor.this.getCallback(message);
            }

            public Validator getValidator(QName qName) throws WSSecurityException {
                Object validator = message.getContextualProperty("ws-security.ut.validator");
                if (validator == null) {
                    return super.getValidator(qName);
                }
                return (Validator)validator;
            }
        };
        ReplayCache nonceCache = WSS4JUtils.getReplayCache(message, "ws-security.enable.nonce.cache", "ws-security.nonce.cache.instance");
        data.setNonceReplayCache(nonceCache);
        WSSConfig config = WSSConfig.getNewInstance();
        boolean bspCompliant = this.isWsiBSPCompliant(message);
        boolean allowNoPassword = this.isAllowNoPassword((AssertionInfoMap)message.get(AssertionInfoMap.class));
        config.setWsiBSPCompliant(bspCompliant);
        config.setAllowUsernameTokenNoPassword(allowNoPassword);
        data.setWssConfig(config);
        List results = p.handleToken(tokenElement, data, wsDocInfo);
        return (WSSecurityEngineResult)results.get(0);
    }

    protected WSUsernameTokenPrincipal parseTokenAndCreatePrincipal(Element tokenElement, boolean bspCompliant) throws WSSecurityException {
        org.apache.ws.security.message.token.UsernameToken ut = new org.apache.ws.security.message.token.UsernameToken(tokenElement, false, bspCompliant);
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(ut.getName(), ut.isHashed());
        principal.setNonce(ut.getNonce());
        principal.setPassword(ut.getPassword());
        principal.setCreatedTime(ut.getCreated());
        principal.setPasswordType(ut.getPasswordType());
        return principal;
    }

    protected boolean isWsiBSPCompliant(SoapMessage message) {
        String bspc = (String)message.getContextualProperty("ws-security.is-bsp-compliant");
        return !"false".equals(bspc) && !"0".equals(bspc);
    }

    private boolean isAllowNoPassword(AssertionInfoMap aim) throws WSSecurityException {
        Collection ais = (Collection)aim.get((Object)SP12Constants.USERNAME_TOKEN);
        if (ais != null && !ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                UsernameToken policy = (UsernameToken)ai.getAssertion();
                if (!policy.isNoPassword()) continue;
                return true;
            }
        }
        return false;
    }

    protected SecurityContext createSecurityContext(Principal p, Subject subject) {
        return new DefaultSecurityContext(p, subject);
    }

    protected Subject createSubject(String name, String password, boolean isDigest, String nonce, String created) throws SecurityException {
        return null;
    }

    @Override
    protected UsernameToken assertTokens(SoapMessage message) {
        return (UsernameToken)this.assertTokens(message, SP12Constants.USERNAME_TOKEN, true);
    }

    private UsernameToken assertTokens(SoapMessage message, WSUsernameTokenPrincipal princ, boolean signed) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        Collection ais = aim.getAssertionInfo(SP12Constants.USERNAME_TOKEN);
        UsernameToken tok = null;
        for (AssertionInfo ai : ais) {
            tok = (UsernameToken)ai.getAssertion();
            if (princ != null && tok.isHashPassword() != princ.isPasswordDigest()) {
                ai.setNotAsserted("Password hashing policy not enforced");
                continue;
            }
            if (princ != null && !tok.isNoPassword() && princ.getPassword() == null && this.isNonEndorsingSupportingToken(tok)) {
                ai.setNotAsserted("Username Token No Password supplied");
                continue;
            }
            ai.setAsserted(true);
        }
        ais = aim.getAssertionInfo(SP12Constants.SUPPORTING_TOKENS);
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
        if (signed || this.isTLSInUse(message)) {
            ais = aim.getAssertionInfo(SP12Constants.SIGNED_SUPPORTING_TOKENS);
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
        return tok;
    }

    private boolean isNonEndorsingSupportingToken(UsernameToken usernameTokenPolicy) {
        SPConstants.SupportTokenType type;
        SupportingToken supportingToken = usernameTokenPolicy.getSupportingToken();
        return supportingToken != null && ((type = supportingToken.getTokenType()) == SPConstants.SupportTokenType.SUPPORTING_TOKEN_SUPPORTING || type == SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED || type == SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED_ENCRYPTED || type == SPConstants.SupportTokenType.SUPPORTING_TOKEN_ENCRYPTED);
    }

    @Override
    protected void addToken(SoapMessage message) {
        UsernameToken tok = this.assertTokens(message);
        Header h = this.findSecurityHeader(message, true);
        WSSecUsernameToken utBuilder = this.addUsernameToken(message, tok);
        if (utBuilder == null) {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            Collection ais = aim.getAssertionInfo(SP12Constants.USERNAME_TOKEN);
            for (AssertionInfo ai : ais) {
                if (!ai.isAsserted()) continue;
                ai.setAsserted(false);
            }
            return;
        }
        Element el = (Element)h.getObject();
        utBuilder.prepare(el.getOwnerDocument());
        el.appendChild(utBuilder.getUsernameTokenElement());
    }

    protected WSSecUsernameToken addUsernameToken(SoapMessage message, UsernameToken token) {
        String userName = (String)message.getContextualProperty("ws-security.username");
        WSSConfig wssConfig = (WSSConfig)message.getContextualProperty(WSSConfig.class.getName());
        if (wssConfig == null) {
            wssConfig = WSSConfig.getNewInstance();
        }
        if (!StringUtils.isEmpty((String)userName)) {
            if (token.isNoPassword()) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(wssConfig);
                utBuilder.setUserInfo(userName, null);
                utBuilder.setPasswordType(null);
                return utBuilder;
            }
            String password = (String)message.getContextualProperty("ws-security.password");
            if (StringUtils.isEmpty((String)password)) {
                password = this.getPassword(userName, token, 2, message);
            }
            if (!StringUtils.isEmpty((String)password)) {
                WSSecUsernameToken utBuilder = new WSSecUsernameToken(wssConfig);
                if (token.isHashPassword()) {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
                } else {
                    utBuilder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                }
                utBuilder.setUserInfo(userName, password);
                return utBuilder;
            }
            this.policyNotAsserted((Token)token, "No username available", message);
        } else {
            this.policyNotAsserted((Token)token, "No username available", message);
        }
        return null;
    }
}

