/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.cocoon.spring.configurator.ResourceFilter;
import org.apache.cocoon.spring.configurator.ResourceUtils;
import org.apache.cocoon.spring.configurator.impl.AbstractElementParser;
import org.apache.cocoon.spring.configurator.impl.ExtendedPropertyOverrideConfigurer;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.w3c.dom.Element;

public abstract class AbstractSettingsElementParser
extends AbstractElementParser {
    private ResourceFilter resourceFilter;

    protected abstract String getRunningMode(Element var1);

    protected abstract void createSettingsBeanFactoryPostProcessor(Element var1, ParserContext var2, String var3);

    protected List getPropertyIncludes(Element childSettingsElement) {
        Element[] propertyDirConfigs;
        ArrayList<String> propertyDirs = null;
        if (childSettingsElement != null && (propertyDirConfigs = this.getChildElements(childSettingsElement, "include-properties")) != null && propertyDirConfigs.length > 0) {
            propertyDirs = new ArrayList<String>();
            for (int i = 0; i < propertyDirConfigs.length; ++i) {
                propertyDirs.add(this.getAttributeValue(propertyDirConfigs[i], "dir", null));
            }
        }
        return propertyDirs;
    }

    protected Properties getAdditionalProperties(Element childSettingsElement) {
        Properties variables = null;
        Element[] properties = this.getChildElements(childSettingsElement, "property");
        if (properties != null && properties.length > 0) {
            variables = new Properties();
            for (int i = 0; i < properties.length; ++i) {
                variables.setProperty(this.getAttributeValue(properties[i], "name", null), this.getAttributeValue(properties[i], "value", null));
            }
        }
        return variables;
    }

    protected List getBeanIncludes(Element childSettingsElement) {
        Element[] includeElements;
        ArrayList<String> includes = new ArrayList<String>();
        if (childSettingsElement.hasChildNodes() && (includeElements = this.getChildElements(childSettingsElement, "include-beans")) != null) {
            for (int i = 0; i < includeElements.length; ++i) {
                String dir = this.getAttributeValue(includeElements[i], "dir", null);
                includes.add(dir);
            }
        }
        return includes;
    }

    protected List getBeanPropertyOverrideIncludes(Element settingsElement) {
        return this.getBeanIncludes(settingsElement);
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String runningMode = this.getRunningMode(element);
        try {
            this.resourceFilter = this.getResourceFilter(element);
        }
        catch (Exception e) {
            throw new BeanDefinitionStoreException("Unable to read filter configuration", (Throwable)e);
        }
        this.createSettingsBeanFactoryPostProcessor(element, parserContext, runningMode);
        List overridePropertyIncludes = this.getBeanPropertyOverrideIncludes(element);
        if (overridePropertyIncludes.size() > 0) {
            this.registerPropertyOverrideConfigurer(parserContext, overridePropertyIncludes);
        }
        this.registerComponents(element, parserContext);
        List beanIncludes = this.getBeanIncludes(element);
        for (String dir : beanIncludes) {
            try {
                this.handleBeanInclude(parserContext, dir, false);
                this.handleBeanInclude(parserContext, dir + "/" + runningMode, true);
            }
            catch (Exception e) {
                throw new BeanDefinitionStoreException("Unable to read spring configurations from " + dir, (Throwable)e);
            }
        }
        return null;
    }

    protected void registerComponents(Element settingsElement, ParserContext parserContext) {
    }

    protected void handleBeanInclude(ParserContext parserContext, String path, boolean optional) throws Exception {
        Resource rsrc;
        ResourcePatternResolver resolver = (ResourcePatternResolver)parserContext.getReaderContext().getReader().getResourceLoader();
        boolean load = true;
        if (optional && !ResourceUtils.isClasspathUri(path) && !(rsrc = resolver.getResource(path)).exists()) {
            load = false;
        }
        if (load) {
            try {
                Resource[] resources = resolver.getResources(path + "/*.xml");
                resources = ResourceUtils.filterResources(resources, this.getResourceFilter());
                Arrays.sort(resources, ResourceUtils.getResourceComparator());
                for (int i = 0; i < resources.length; ++i) {
                    this.handleImport(parserContext, resources[i].getURL().toExternalForm());
                }
            }
            catch (IOException ioe) {
                throw new Exception("Unable to read configurations from " + path, ioe);
            }
        }
    }

    protected void handleImport(ParserContext parserContext, String uri) {
        ResourceLoader resourceLoader = parserContext.getReaderContext().getReader().getResourceLoader();
        parserContext.getDelegate().getReaderContext().getReader().loadBeanDefinitions(resourceLoader.getResource(uri));
    }

    protected void registerPropertyOverrideConfigurer(ParserContext parserContext, List locations) {
        RootBeanDefinition beanDef = this.createBeanDefinition(ExtendedPropertyOverrideConfigurer.class.getName(), null, true);
        beanDef.getPropertyValues().addPropertyValue("locations", (Object)locations);
        beanDef.getPropertyValues().addPropertyValue("resourceLoader", (Object)parserContext.getReaderContext().getReader().getResourceLoader());
        beanDef.getPropertyValues().addPropertyValue("resourceFilter", (Object)this.getResourceFilter());
        beanDef.getPropertyValues().addPropertyValue("beanNameSeparator", (Object)"/");
        this.register((BeanDefinition)beanDef, ExtendedPropertyOverrideConfigurer.class.getName(), parserContext.getRegistry());
    }

    protected ResourceFilter getResourceFilter(Element e) throws Exception {
        Element[] filters = this.getChildElements(e, "filter");
        if (filters.length == 0) {
            return null;
        }
        if (filters.length > 1) {
            throw new RuntimeException("Only one filter definition is allowed and you configured " + filters.length + " filters.");
        }
        String filterClassName = filters[0].getAttribute("class");
        if (filterClassName.length() == 0) {
            throw new RuntimeException("Missing 'class' attribute.");
        }
        return (ResourceFilter)Class.forName(filterClassName).newInstance();
    }

    protected final ResourceFilter getResourceFilter() {
        return this.resourceFilter;
    }
}

