/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.camel.maven.packaging.ErrorDetail;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.StringHelper;

public final class ValidateHelper {
    private ValidateHelper() {
    }

    public static void validate(File file, ErrorDetail errorDetail) {
        try {
            String json = PackageHelper.loadText(new FileInputStream(file));
            boolean isComponent = json.contains("\"kind\": \"component\"");
            boolean isDataFormat = json.contains("\"kind\": \"dataformat\"");
            boolean isLanguage = json.contains("\"kind\": \"language\"");
            if (!(isComponent || isDataFormat || isLanguage)) {
                return;
            }
            if (isComponent) {
                errorDetail.setKind("component");
            } else if (isDataFormat) {
                errorDetail.setKind("dataformat");
            } else if (isLanguage) {
                errorDetail.setKind("language");
            }
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema(errorDetail.getKind(), json, false);
            boolean label = false;
            boolean description = false;
            boolean syntax = false;
            for (Map<String, String> row : rows) {
                String value = row.get("label");
                if (!StringHelper.isEmpty(value)) {
                    label = true;
                }
                if (!StringHelper.isEmpty(value = row.get("description"))) {
                    description = true;
                }
                if (StringHelper.isEmpty(value = row.get("syntax"))) continue;
                syntax = true;
            }
            if (!label) {
                errorDetail.setMissingLabel(true);
            }
            if (!description) {
                errorDetail.setMissingDescription(true);
            }
            if (!syntax && isComponent) {
                errorDetail.setMissingSyntax(true);
            }
            if (isComponent) {
                rows = JSonSchemaHelper.parseJsonSchema("componentProperties", json, true);
                for (Map<String, String> row : rows) {
                    String key = row.get("name");
                    String doc = row.get("description");
                    if (doc != null && !doc.isEmpty()) continue;
                    errorDetail.addMissingComponentDoc(key);
                }
            }
            rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
            boolean path = false;
            for (Map<String, String> row : rows) {
                String kind;
                String key = row.get("name");
                String doc = row.get("description");
                if (doc == null || doc.isEmpty()) {
                    errorDetail.addMissingEndpointDoc(key);
                }
                if (!"path".equals(kind = row.get("kind"))) continue;
                path = true;
            }
            if (isComponent && !path) {
                errorDetail.setMissingUriPath(true);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String asName(File file) {
        String name = file.getName();
        if (name.endsWith(".json")) {
            return name.substring(0, name.length() - 5);
        }
        return name;
    }
}

