/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.reader.NullXMLStreamReader;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.util.StreamWrapper;

public class RPCUtil {
    private static String RETURN_WRAPPER = "return";

    public static void processResponse(SOAPFactory fac, Object resObject, OMElement bodyContent, OMNamespace ns, SOAPEnvelope envelope, Method method, boolean qualified, TypeTable typeTable) {
        if (resObject != null) {
            if (resObject instanceof OMElement) {
                OMElement result = (OMElement)resObject;
                bodyContent = fac.createOMElement(method.getName() + "Response", ns);
                OMElement resWrapper = qualified ? fac.createOMElement(RETURN_WRAPPER, ns.getNamespaceURI(), ns.getPrefix()) : fac.createOMElement(RETURN_WRAPPER, null);
                resWrapper.addChild((OMNode)result);
                bodyContent.addChild((OMNode)resWrapper);
            } else if (SimpleTypeMapper.isSimpleType(resObject)) {
                bodyContent = fac.createOMElement(method.getName() + "Response", ns);
                OMElement child = qualified ? fac.createOMElement(RETURN_WRAPPER, ns) : fac.createOMElement(RETURN_WRAPPER, null);
                child.addChild((OMNode)fac.createOMText((OMContainer)child, SimpleTypeMapper.getStringValue(resObject)));
                bodyContent.addChild((OMNode)child);
            } else {
                bodyContent = fac.createOMElement(method.getName() + "Response", ns);
                QName returnWrapper = qualified ? new QName(ns.getNamespaceURI(), RETURN_WRAPPER, ns.getPrefix()) : new QName(RETURN_WRAPPER);
                XMLStreamReader xr = BeanUtil.getPullParser(resObject, returnWrapper, typeTable, qualified, false);
                StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)new StreamWrapper(xr));
                OMElement documentElement = stAXOMBuilder.getDocumentElement();
                if (documentElement != null) {
                    bodyContent.addChild((OMNode)documentElement);
                }
            }
        }
        if (bodyContent != null) {
            envelope.getBody().addChild((OMNode)bodyContent);
        }
    }

    public static void processObjectAsDocLitBare(SOAPFactory fac, Object resObject, OMElement bodyContent, OMNamespace ns, SOAPEnvelope envelope, boolean qualified, TypeTable typeTable, String partName) {
        if (resObject instanceof OMElement) {
            OMElement result = (OMElement)resObject;
            bodyContent = fac.createOMElement(partName, ns);
            bodyContent.addChild((OMNode)result);
        } else if (SimpleTypeMapper.isSimpleType(resObject)) {
            bodyContent = fac.createOMElement(partName, ns);
            bodyContent.addChild((OMNode)fac.createOMText((OMContainer)bodyContent, SimpleTypeMapper.getStringValue(resObject)));
        } else {
            QName returnWrapper = new QName(ns.getNamespaceURI(), partName, ns.getPrefix());
            XMLStreamReader xr = BeanUtil.getPullParser(resObject, returnWrapper, typeTable, qualified, true);
            StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)new StreamWrapper(xr));
            OMElement documentElement = stAXOMBuilder.getDocumentElement();
            if (documentElement != null) {
                envelope.getBody().addChild((OMNode)documentElement);
            }
        }
        if (bodyContent != null) {
            envelope.getBody().addChild((OMNode)bodyContent);
        }
    }

    public static Object[] processRequest(OMElement methodElement, Method method, ObjectSupplier objectSupplier) throws AxisFault {
        Object[] parameters = method.getParameterTypes();
        return BeanUtil.deserialize(methodElement, parameters, objectSupplier);
    }

    public static Object invokeServiceClass(AxisMessage inAxisMessage, Method method, Object implClass, String messageNameSpace, OMElement methodElement, MessageContext inMessage) throws AxisFault, IllegalAccessException, InvocationTargetException {
        if (inAxisMessage.getElementQName() == null) {
            return method.invoke(implClass, new Object[0]);
        }
        QName elementQName = inAxisMessage.getElementQName();
        messageNameSpace = elementQName.getNamespaceURI();
        OMNamespace namespace = methodElement.getNamespace();
        if (messageNameSpace != null) {
            if (namespace == null) {
                throw new AxisFault("namespace mismatch require " + messageNameSpace + " found none");
            }
            if (!messageNameSpace.equals(namespace.getNamespaceURI())) {
                throw new AxisFault("namespace mismatch require " + messageNameSpace + " found " + methodElement.getNamespace().getNamespaceURI());
            }
        } else if (namespace != null) {
            throw new AxisFault("namespace mismatch. Axis Oepration expects non-namespace qualified element. But received a namespace qualified element");
        }
        Object[] objectArray = inAxisMessage.isWrapped() ? RPCUtil.processRequest(methodElement, method, inMessage.getAxisService().getObjectSupplier()) : RPCUtil.processRequest((OMElement)methodElement.getParent(), method, inMessage.getAxisService().getObjectSupplier());
        return method.invoke(implClass, objectArray);
    }

    public static OMElement getResponseElement(QName resname, Object[] objs, boolean qualified, TypeTable typeTable) {
        if (qualified) {
            return BeanUtil.getOMElement(resname, objs, new QName(resname.getNamespaceURI(), RETURN_WRAPPER, resname.getPrefix()), qualified, typeTable);
        }
        return BeanUtil.getOMElement(resname, objs, new QName(RETURN_WRAPPER), qualified, typeTable);
    }

    public static void processResonseAsDocLitBare(Object resObject, AxisService service, SOAPEnvelope envelope, SOAPFactory fac, OMNamespace ns, OMElement bodyContent, MessageContext outMessage) throws Exception {
        QName elementQName = outMessage.getAxisMessage().getElementQName();
        String partName = outMessage.getAxisMessage().getPartName();
        if (resObject == null) {
            RPCUtil.processNullReturns(service, envelope, partName);
        } else if (resObject instanceof Object[]) {
            QName resName = new QName(elementQName.getNamespaceURI(), partName, elementQName.getPrefix());
            OMElement bodyChild = RPCUtil.getResponseElement(resName, (Object[])resObject, service.isElementFormDefault(), service.getTypeTable());
            envelope.getBody().addChild((OMNode)bodyChild);
        } else if (resObject.getClass().isArray()) {
            Object[] objArray;
            int length = Array.getLength(resObject);
            if (resObject instanceof byte[]) {
                objArray = new Object[]{Base64.encode((byte[])((byte[])resObject))};
            } else {
                objArray = new Object[length];
                for (int i = 0; i < length; ++i) {
                    objArray[i] = Array.get(resObject, i);
                }
            }
            QName resName = new QName(elementQName.getNamespaceURI(), partName, elementQName.getPrefix());
            OMElement bodyChild = RPCUtil.getResponseElement(resName, objArray, service.isElementFormDefault(), service.getTypeTable());
            envelope.getBody().addChild((OMNode)bodyChild);
        } else if (SimpleTypeMapper.isCollection(resObject.getClass())) {
            Collection collection = (Collection)resObject;
            int size = collection.size();
            Object[] values = new Object[size];
            int count = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                values[count] = iterator.next();
                ++count;
            }
            QName resName = new QName(elementQName.getNamespaceURI(), partName, elementQName.getPrefix());
            OMElement bodyChild = RPCUtil.getResponseElement(resName, values, service.isElementFormDefault(), service.getTypeTable());
            envelope.getBody().addChild((OMNode)bodyChild);
        } else if (SimpleTypeMapper.isDataHandler(resObject.getClass())) {
            OMElement resElemt = service.isElementFormDefault() ? fac.createOMElement(partName, ns) : fac.createOMElement(partName, null);
            OMText text = fac.createOMText(resObject, true);
            resElemt.addChild((OMNode)text);
            envelope.getBody().addChild((OMNode)resElemt);
        } else if (service.isElementFormDefault()) {
            RPCUtil.processObjectAsDocLitBare(fac, resObject, bodyContent, ns, envelope, service.isElementFormDefault(), service.getTypeTable(), partName);
        } else {
            RPCUtil.processObjectAsDocLitBare(fac, resObject, bodyContent, ns, envelope, service.isElementFormDefault(), null, partName);
        }
        outMessage.setEnvelope(envelope);
    }

    private static void processNullReturns(AxisService service, SOAPEnvelope envelope, String partName) {
        QName resName = service.isElementFormDefault() ? new QName(service.getSchemaTargetNamespace(), partName, service.getSchemaTargetNamespacePrefix()) : new QName(partName);
        NullXMLStreamReader xr = new NullXMLStreamReader(resName);
        StreamWrapper parser = new StreamWrapper((XMLStreamReader)xr);
        StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getSOAP11Factory(), (XMLStreamReader)parser);
        envelope.getBody().addChild((OMNode)stAXOMBuilder.getDocumentElement());
    }

    public static void processResponseAsDocLitWrapped(Object resObject, AxisService service, Method method, SOAPEnvelope envelope, SOAPFactory fac, OMNamespace ns, OMElement bodyContent, MessageContext outMessage) throws Exception {
        QName elementQName = outMessage.getAxisMessage().getElementQName();
        if (resObject == null) {
            QName resName = service.isElementFormDefault() ? new QName(service.getSchemaTargetNamespace(), RETURN_WRAPPER, service.getSchemaTargetNamespacePrefix()) : new QName(RETURN_WRAPPER);
            NullXMLStreamReader xr = new NullXMLStreamReader(resName);
            StreamWrapper parser = new StreamWrapper((XMLStreamReader)xr);
            StAXOMBuilder stAXOMBuilder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getSOAP11Factory(), (XMLStreamReader)parser);
            ns = fac.createOMNamespace(service.getSchemaTargetNamespace(), service.getSchemaTargetNamespacePrefix());
            OMElement bodyChild = fac.createOMElement(method.getName() + "Response", ns);
            bodyChild.addChild((OMNode)stAXOMBuilder.getDocumentElement());
            envelope.getBody().addChild((OMNode)bodyChild);
        } else if (resObject instanceof Object[]) {
            QName resName = new QName(elementQName.getNamespaceURI(), method.getName() + "Response", elementQName.getPrefix());
            OMElement bodyChild = RPCUtil.getResponseElement(resName, (Object[])resObject, service.isElementFormDefault(), service.getTypeTable());
            envelope.getBody().addChild((OMNode)bodyChild);
        } else if (resObject.getClass().isArray()) {
            Object[] objArray;
            int length = Array.getLength(resObject);
            if (resObject instanceof byte[]) {
                objArray = new Object[]{Base64.encode((byte[])((byte[])resObject))};
            } else {
                objArray = new Object[length];
                for (int i = 0; i < length; ++i) {
                    objArray[i] = Array.get(resObject, i);
                }
            }
            QName resName = new QName(elementQName.getNamespaceURI(), method.getName() + "Response", elementQName.getPrefix());
            OMElement bodyChild = RPCUtil.getResponseElement(resName, objArray, service.isElementFormDefault(), service.getTypeTable());
            envelope.getBody().addChild((OMNode)bodyChild);
        } else if (SimpleTypeMapper.isCollection(resObject.getClass())) {
            Collection collection = (Collection)resObject;
            int size = collection.size();
            Object[] values = new Object[size];
            int count = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                values[count] = iterator.next();
                ++count;
            }
            QName resName = new QName(elementQName.getNamespaceURI(), method.getName() + "Response", elementQName.getPrefix());
            OMElement bodyChild = RPCUtil.getResponseElement(resName, values, service.isElementFormDefault(), service.getTypeTable());
            envelope.getBody().addChild((OMNode)bodyChild);
        } else if (SimpleTypeMapper.isDataHandler(resObject.getClass())) {
            OMElement resElemt = fac.createOMElement(method.getName() + "Response", ns);
            OMText text = fac.createOMText(resObject, true);
            OMElement returnElement = service.isElementFormDefault() ? fac.createOMElement(RETURN_WRAPPER, ns) : fac.createOMElement(RETURN_WRAPPER, null);
            returnElement.addChild((OMNode)text);
            resElemt.addChild((OMNode)returnElement);
            envelope.getBody().addChild((OMNode)resElemt);
        } else if (service.isElementFormDefault()) {
            RPCUtil.processResponse(fac, resObject, bodyContent, ns, envelope, method, service.isElementFormDefault(), service.getTypeTable());
        } else {
            RPCUtil.processResponse(fac, resObject, bodyContent, ns, envelope, method, service.isElementFormDefault(), null);
        }
        outMessage.setEnvelope(envelope);
    }
}

