/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v5;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v5.BaseDataStreamMarshaller;

public class JournalTopicAckMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 50;
    }

    @Override
    public DataStructure createObject() {
        return new JournalTopicAck();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        JournalTopicAck info2 = (JournalTopicAck)o;
        info2.setDestination((ActiveMQDestination)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setMessageId((MessageId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setMessageSequenceId(this.tightUnmarshalLong(wireFormat, dataIn, bs));
        info2.setSubscritionName(this.tightUnmarshalString(dataIn, bs));
        info2.setClientId(this.tightUnmarshalString(dataIn, bs));
        info2.setTransactionId((TransactionId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        JournalTopicAck info2 = (JournalTopicAck)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalNestedObject1(wireFormat, info2.getDestination(), bs);
        rc += this.tightMarshalNestedObject1(wireFormat, info2.getMessageId(), bs);
        rc += this.tightMarshalLong1(wireFormat, info2.getMessageSequenceId(), bs);
        rc += this.tightMarshalString1(info2.getSubscritionName(), bs);
        rc += this.tightMarshalString1(info2.getClientId(), bs);
        return (rc += this.tightMarshalNestedObject1(wireFormat, info2.getTransactionId(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        JournalTopicAck info2 = (JournalTopicAck)o;
        this.tightMarshalNestedObject2(wireFormat, info2.getDestination(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, info2.getMessageId(), dataOut, bs);
        this.tightMarshalLong2(wireFormat, info2.getMessageSequenceId(), dataOut, bs);
        this.tightMarshalString2(info2.getSubscritionName(), dataOut, bs);
        this.tightMarshalString2(info2.getClientId(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, info2.getTransactionId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        JournalTopicAck info2 = (JournalTopicAck)o;
        info2.setDestination((ActiveMQDestination)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setMessageId((MessageId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setMessageSequenceId(this.looseUnmarshalLong(wireFormat, dataIn));
        info2.setSubscritionName(this.looseUnmarshalString(dataIn));
        info2.setClientId(this.looseUnmarshalString(dataIn));
        info2.setTransactionId((TransactionId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        JournalTopicAck info2 = (JournalTopicAck)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getDestination(), dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getMessageId(), dataOut);
        this.looseMarshalLong(wireFormat, info2.getMessageSequenceId(), dataOut);
        this.looseMarshalString(info2.getSubscritionName(), dataOut);
        this.looseMarshalString(info2.getClientId(), dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getTransactionId(), dataOut);
    }
}

