/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v1;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v1.BaseCommandMarshaller;

public class MessageAckMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 22;
    }

    @Override
    public DataStructure createObject() {
        return new MessageAck();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        MessageAck info2 = (MessageAck)o;
        info2.setDestination((ActiveMQDestination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setTransactionId((TransactionId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setAckType(dataIn.readByte());
        info2.setFirstMessageId((MessageId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setLastMessageId((MessageId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setMessageCount(dataIn.readInt());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        MessageAck info2 = (MessageAck)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getDestination(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getTransactionId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getConsumerId(), bs);
        rc += this.tightMarshalNestedObject1(wireFormat, info2.getFirstMessageId(), bs);
        return (rc += this.tightMarshalNestedObject1(wireFormat, info2.getLastMessageId(), bs)) + 5;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        MessageAck info2 = (MessageAck)o;
        this.tightMarshalCachedObject2(wireFormat, info2.getDestination(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getTransactionId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getConsumerId(), dataOut, bs);
        dataOut.writeByte(info2.getAckType());
        this.tightMarshalNestedObject2(wireFormat, info2.getFirstMessageId(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, info2.getLastMessageId(), dataOut, bs);
        dataOut.writeInt(info2.getMessageCount());
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        MessageAck info2 = (MessageAck)o;
        info2.setDestination((ActiveMQDestination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setTransactionId((TransactionId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setAckType(dataIn.readByte());
        info2.setFirstMessageId((MessageId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setLastMessageId((MessageId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setMessageCount(dataIn.readInt());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        MessageAck info2 = (MessageAck)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getDestination(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getTransactionId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getConsumerId(), dataOut);
        dataOut.writeByte(info2.getAckType());
        this.looseMarshalNestedObject(wireFormat, info2.getFirstMessageId(), dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getLastMessageId(), dataOut);
        dataOut.writeInt(info2.getMessageCount());
    }
}

