/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.activemq.wireformat.WireFormatFactory;

public class OpenWireFormatFactory
implements WireFormatFactory {
    private int version = 9;
    private boolean stackTraceEnabled = true;
    private boolean tcpNoDelayEnabled = true;
    private boolean cacheEnabled = true;
    private boolean tightEncodingEnabled = true;
    private boolean sizePrefixDisabled;
    private long maxInactivityDuration = 30000L;
    private long maxInactivityDurationInitalDelay = 10000L;
    private int cacheSize = 1024;
    private long maxFrameSize = Long.MAX_VALUE;

    @Override
    public WireFormat createWireFormat() {
        WireFormatInfo info2 = new WireFormatInfo();
        info2.setVersion(this.version);
        try {
            info2.setStackTraceEnabled(this.stackTraceEnabled);
            info2.setCacheEnabled(this.cacheEnabled);
            info2.setTcpNoDelayEnabled(this.tcpNoDelayEnabled);
            info2.setTightEncodingEnabled(this.tightEncodingEnabled);
            info2.setSizePrefixDisabled(this.sizePrefixDisabled);
            info2.setMaxInactivityDuration(this.maxInactivityDuration);
            info2.setMaxInactivityDurationInitalDelay(this.maxInactivityDurationInitalDelay);
            info2.setCacheSize(this.cacheSize);
            info2.setMaxFrameSize(this.maxFrameSize);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Could not configure WireFormatInfo");
            ise.initCause(e);
            throw ise;
        }
        OpenWireFormat f = new OpenWireFormat(this.version);
        f.setMaxFrameSize(this.maxFrameSize);
        f.setPreferedWireFormatInfo(info2);
        return f;
    }

    public boolean isStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public void setStackTraceEnabled(boolean stackTraceEnabled) {
        this.stackTraceEnabled = stackTraceEnabled;
    }

    public boolean isTcpNoDelayEnabled() {
        return this.tcpNoDelayEnabled;
    }

    public void setTcpNoDelayEnabled(boolean tcpNoDelayEnabled) {
        this.tcpNoDelayEnabled = tcpNoDelayEnabled;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isTightEncodingEnabled() {
        return this.tightEncodingEnabled;
    }

    public void setTightEncodingEnabled(boolean tightEncodingEnabled) {
        this.tightEncodingEnabled = tightEncodingEnabled;
    }

    public boolean isSizePrefixDisabled() {
        return this.sizePrefixDisabled;
    }

    public void setSizePrefixDisabled(boolean sizePrefixDisabled) {
        this.sizePrefixDisabled = sizePrefixDisabled;
    }

    public long getMaxInactivityDuration() {
        return this.maxInactivityDuration;
    }

    public void setMaxInactivityDuration(long maxInactivityDuration) {
        this.maxInactivityDuration = maxInactivityDuration;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public long getMaxInactivityDurationInitalDelay() {
        return this.maxInactivityDurationInitalDelay;
    }

    public void setMaxInactivityDurationInitalDelay(long maxInactivityDurationInitalDelay) {
        this.maxInactivityDurationInitalDelay = maxInactivityDurationInitalDelay;
    }

    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }
}

