/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.activemq.kaha.impl.container.ContainerCollectionSupport;
import org.apache.activemq.kaha.impl.container.ContainerKeySetIterator;
import org.apache.activemq.kaha.impl.container.MapContainerImpl;
import org.apache.activemq.kaha.impl.index.IndexItem;

public class ContainerKeySet
extends ContainerCollectionSupport
implements Set {
    ContainerKeySet(MapContainerImpl container) {
        super(container);
    }

    @Override
    public boolean contains(Object o) {
        return this.container.containsKey(o);
    }

    @Override
    public Iterator iterator() {
        return new ContainerKeySetIterator(this.container);
    }

    @Override
    public Object[] toArray() {
        ArrayList<Object> list = new ArrayList<Object>();
        IndexItem item = this.container.getInternalList().getRoot();
        while ((item = this.container.getInternalList().getNextEntry(item)) != null) {
            list.add(this.container.getKey(item));
        }
        return list.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        ArrayList<Object> list = new ArrayList<Object>();
        IndexItem item = this.container.getInternalList().getRoot();
        while ((item = this.container.getInternalList().getNextEntry(item)) != null) {
            list.add(this.container.getKey(item));
        }
        return list.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException("Cannot add here");
    }

    @Override
    public boolean remove(Object o) {
        return this.container.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object key : c) {
            if (this.container.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("Cannot add here");
    }

    @Override
    public boolean retainAll(Collection c) {
        ArrayList tmpList = new ArrayList();
        for (Object o : c) {
            if (this.contains(o)) continue;
            tmpList.add(o);
        }
        Iterator i = tmpList.iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
        return !tmpList.isEmpty();
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean result = true;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.remove(i.next())) continue;
            result = false;
        }
        return result;
    }

    @Override
    public void clear() {
        this.container.clear();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(32);
        result.append("ContainerKeySet[");
        IndexItem item = this.container.getInternalList().getRoot();
        while ((item = this.container.getInternalList().getNextEntry(item)) != null) {
            result.append(this.container.getKey(item));
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }
}

