/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store.amq;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.JournalTransaction;
import org.apache.activemq.console.command.store.amq.CommandLineSupport;
import org.apache.activemq.console.command.store.amq.CustomResourceLoader;
import org.apache.activemq.console.command.store.amq.Entry;
import org.apache.activemq.console.command.store.amq.MessageBodyFormatter;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.kaha.impl.async.ReadOnlyAsyncDataManager;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.josql.Query;

public class AMQJournalTool {
    private final ArrayList<File> dirs = new ArrayList();
    private final WireFormat wireFormat = new OpenWireFormat();
    private final HashMap<String, String> resources = new HashMap();
    private String messageFormat = "${location.dataFileId},${location.offset}|${type}|${record.destination}|${record.messageId}|${record.properties}|${body}";
    private String topicAckFormat = "${location.dataFileId},${location.offset}|${type}|${record.destination}|${record.clientId}|${record.subscritionName}|${record.messageId}";
    private String queueAckFormat = "${location.dataFileId},${location.offset}|${type}|${record.destination}|${record.messageAck.lastMessageId}";
    private String transactionFormat = "${location.dataFileId},${location.offset}|${type}|${record.transactionId}";
    private String traceFormat = "${location.dataFileId},${location.offset}|${type}|${record.message}";
    private String unknownFormat = "${location.dataFileId},${location.offset}|${type}|${record.class.name}";
    private String where;
    private VelocityContext context;
    private VelocityEngine velocity;
    private boolean help;

    public static void main(String[] args) throws Exception {
        AMQJournalTool consumerTool = new AMQJournalTool();
        String[] directories = CommandLineSupport.setOptions(consumerTool, args);
        if (directories.length < 1) {
            System.out.println("Please specify the directories with journal data to scan");
            return;
        }
        for (int i = 0; i < directories.length; ++i) {
            consumerTool.getDirs().add(new File(directories[i]));
        }
        consumerTool.execute();
    }

    protected VelocityContext createVelocityContext() {
        VelocityContext ctx = new VelocityContext();
        List<Object> keys = Arrays.asList(ctx.getKeys());
        for (Map.Entry<Object, Object> kv : System.getProperties().entrySet()) {
            String name = (String)kv.getKey();
            String value = (String)kv.getValue();
            if (keys.contains(name)) continue;
            ctx.put(name, (Object)value);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        if (this.help) {
            this.showHelp();
            return;
        }
        if (this.getDirs().size() < 1) {
            System.out.println("");
            System.out.println("Invalid Usage: Please specify the directories with journal data to scan");
            System.out.println("");
            this.showHelp();
            return;
        }
        for (File dir : this.getDirs()) {
            if (!dir.exists()) {
                System.out.println("");
                System.out.println("Invalid Usage: the directory '" + dir.getPath() + "' does not exist");
                System.out.println("");
                this.showHelp();
                return;
            }
            if (dir.isDirectory()) continue;
            System.out.println("");
            System.out.println("Invalid Usage: the argument '" + dir.getPath() + "' is not a directory");
            System.out.println("");
            this.showHelp();
            return;
        }
        this.context = this.createVelocityContext();
        this.velocity = new VelocityEngine();
        this.velocity.setProperty("resource.loader", (Object)"all");
        this.velocity.setProperty("all.resource.loader.class", (Object)CustomResourceLoader.class.getName());
        this.velocity.init();
        this.resources.put("message", this.messageFormat);
        this.resources.put("topicAck", this.topicAckFormat);
        this.resources.put("queueAck", this.queueAckFormat);
        this.resources.put("transaction", this.transactionFormat);
        this.resources.put("trace", this.traceFormat);
        this.resources.put("unknown", this.unknownFormat);
        Query query = null;
        if (this.where != null) {
            query = new Query();
            query.parse("select * from " + Entry.class.getName() + " where " + this.where);
        }
        ReadOnlyAsyncDataManager manager = new ReadOnlyAsyncDataManager(this.getDirs());
        manager.start();
        try {
            Location curr = manager.getFirstLocation();
            while (curr != null) {
                ByteSequence data = manager.read(curr);
                DataStructure c = (DataStructure)this.wireFormat.unmarshal(data);
                Entry entry = new Entry();
                entry.setLocation(curr);
                entry.setRecord(c);
                entry.setData(data);
                entry.setQuery(query);
                this.process(entry);
                curr = manager.getNextLocation(curr);
            }
        }
        finally {
            manager.close();
        }
    }

    private void showHelp() {
        InputStream is = AMQJournalTool.class.getResourceAsStream("help.txt");
        Scanner scanner = new Scanner(is);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            System.out.println(line);
        }
        scanner.close();
    }

    private void process(Entry entry) throws Exception {
        DataStructure record = entry.getRecord();
        switch (record.getDataStructureType()) {
            case 23: {
                entry.setType("ActiveMQMessage");
                entry.setFormater("message");
                this.display(entry);
                break;
            }
            case 24: {
                entry.setType("ActiveMQBytesMessage");
                entry.setFormater("message");
                this.display(entry);
                break;
            }
            case 29: {
                entry.setType("ActiveMQBlobMessage");
                entry.setFormater("message");
                this.display(entry);
                break;
            }
            case 25: {
                entry.setType("ActiveMQMapMessage");
                entry.setFormater("message");
                this.display(entry);
                break;
            }
            case 26: {
                entry.setType("ActiveMQObjectMessage");
                entry.setFormater("message");
                this.display(entry);
                break;
            }
            case 27: {
                entry.setType("ActiveMQStreamMessage");
                entry.setFormater("message");
                this.display(entry);
                break;
            }
            case 28: {
                entry.setType("ActiveMQTextMessage");
                entry.setFormater("message");
                this.display(entry);
                break;
            }
            case 52: {
                entry.setType("Queue Ack");
                entry.setFormater("queueAck");
                this.display(entry);
                break;
            }
            case 50: {
                entry.setType("Topic Ack");
                entry.setFormater("topicAck");
                this.display(entry);
                break;
            }
            case 54: {
                entry.setType(this.getType((JournalTransaction)record));
                entry.setFormater("transaction");
                this.display(entry);
                break;
            }
            case 53: {
                entry.setType("Trace");
                entry.setFormater("trace");
                this.display(entry);
                break;
            }
            default: {
                entry.setType("Unknown");
                entry.setFormater("unknown");
                this.display(entry);
            }
        }
    }

    private String getType(JournalTransaction record) {
        switch (record.getType()) {
            case 1: {
                return "XA Prepare";
            }
            case 2: {
                return "XA Commit";
            }
            case 3: {
                return "XA Rollback";
            }
            case 4: {
                return "Commit";
            }
            case 5: {
                return "Rollback";
            }
        }
        return "Unknown Transaction";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void display(Entry entry) throws Exception {
        if (entry.getQuery() != null) {
            List<Entry> list = Collections.singletonList(entry);
            List results = entry.getQuery().execute(list).getResults();
            if (results.isEmpty()) {
                return;
            }
        }
        CustomResourceLoader.setResources(this.resources);
        try {
            this.context.put("location", (Object)entry.getLocation());
            this.context.put("record", (Object)entry.getRecord());
            this.context.put("type", (Object)entry.getType());
            if (entry.getRecord() instanceof ActiveMQMessage) {
                this.context.put("body", (Object)new MessageBodyFormatter((ActiveMQMessage)entry.getRecord()));
            }
            Template template = this.velocity.getTemplate(entry.getFormater());
            PrintWriter writer = new PrintWriter(System.out);
            template.merge((Context)this.context, (Writer)writer);
            writer.println();
            writer.flush();
        }
        finally {
            CustomResourceLoader.setResources(null);
        }
    }

    public void setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
    }

    public void setTopicAckFormat(String ackFormat) {
        this.topicAckFormat = ackFormat;
    }

    public void setTransactionFormat(String transactionFormat) {
        this.transactionFormat = transactionFormat;
    }

    public void setTraceFormat(String traceFormat) {
        this.traceFormat = traceFormat;
    }

    public void setUnknownFormat(String unknownFormat) {
        this.unknownFormat = unknownFormat;
    }

    public void setQueueAckFormat(String queueAckFormat) {
        this.queueAckFormat = queueAckFormat;
    }

    public String getQuery() {
        return this.where;
    }

    public void setWhere(String query) {
        this.where = query;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public ArrayList<File> getDirs() {
        return this.dirs;
    }
}

