/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.OrderedPendingList;
import org.apache.activemq.broker.region.cursors.PendingList;
import org.apache.activemq.broker.region.cursors.PendingNode;
import org.apache.activemq.command.MessageId;

public class PrioritizedPendingList
implements PendingList {
    private static final Integer MAX_PRIORITY = 10;
    private final OrderedPendingList[] lists = new OrderedPendingList[MAX_PRIORITY.intValue()];
    private final Map<MessageId, PendingNode> map = new HashMap<MessageId, PendingNode>();

    public PrioritizedPendingList() {
        for (int i = 0; i < MAX_PRIORITY; ++i) {
            this.lists[i] = new OrderedPendingList();
        }
    }

    @Override
    public PendingNode addMessageFirst(MessageReference message) {
        PendingNode node = this.getList(message).addMessageFirst(message);
        this.map.put(message.getMessageId(), node);
        return node;
    }

    @Override
    public PendingNode addMessageLast(MessageReference message) {
        PendingNode node = this.getList(message).addMessageLast(message);
        this.map.put(message.getMessageId(), node);
        return node;
    }

    @Override
    public void clear() {
        for (int i = 0; i < MAX_PRIORITY; ++i) {
            this.lists[i].clear();
        }
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<MessageReference> iterator() {
        return new PrioritizedPendingListIterator();
    }

    @Override
    public PendingNode remove(MessageReference message) {
        PendingNode node = null;
        if (message != null && (node = this.map.remove(message.getMessageId())) != null) {
            node.getList().removeNode(node);
        }
        return node;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return "PrioritizedPendingList(" + System.identityHashCode(this) + ")";
    }

    protected int getPriority(MessageReference message) {
        int priority = 4;
        if (message.getMessageId() != null) {
            priority = Math.max(message.getMessage().getPriority(), 0);
            priority = Math.min(priority, 9);
        }
        return priority;
    }

    protected OrderedPendingList getList(MessageReference msg) {
        return this.lists[this.getPriority(msg)];
    }

    @Override
    public boolean contains(MessageReference message) {
        return this.map.values().contains(message);
    }

    @Override
    public Collection<MessageReference> values() {
        ArrayList<MessageReference> messageReferences = new ArrayList<MessageReference>();
        for (PendingNode pendingNode : this.map.values()) {
            messageReferences.add(pendingNode.getMessage());
        }
        return messageReferences;
    }

    @Override
    public void addAll(PendingList pendingList) {
        for (MessageReference messageReference : pendingList) {
            this.addMessageLast(messageReference);
        }
    }

    private class PrioritizedPendingListIterator
    implements Iterator<MessageReference> {
        private int index = 0;
        private int currentIndex = 0;
        List<PendingNode> list = new ArrayList<PendingNode>(PrioritizedPendingList.this.size());

        PrioritizedPendingListIterator() {
            for (int i = MAX_PRIORITY - 1; i >= 0; --i) {
                OrderedPendingList orderedPendingList = PrioritizedPendingList.this.lists[i];
                if (orderedPendingList.isEmpty()) continue;
                this.list.addAll(orderedPendingList.getAsList());
            }
        }

        @Override
        public boolean hasNext() {
            return this.list.size() > this.index;
        }

        @Override
        public MessageReference next() {
            PendingNode node = this.list.get(this.index);
            this.currentIndex = this.index++;
            return node.getMessage();
        }

        @Override
        public void remove() {
            PendingNode node = this.list.get(this.currentIndex);
            if (node != null) {
                PrioritizedPendingList.this.map.remove(node.getMessage().getMessageId());
                node.getList().removeNode(node);
            }
        }
    }
}

