/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.Map;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.Assert;

public class SystemEnvironmentPropertySource
extends MapPropertySource {
    public SystemEnvironmentPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    @Override
    public boolean containsProperty(String name) {
        return this.getProperty(name) != null;
    }

    @Override
    public Object getProperty(String name) {
        String actualName = this.resolvePropertyName(name);
        if (this.logger.isDebugEnabled() && !name.equals(actualName)) {
            this.logger.debug(String.format("PropertySource [%s] does not contain '%s', but found equivalent '%s'", this.getName(), name, actualName));
        }
        return super.getProperty(actualName);
    }

    private String resolvePropertyName(String name) {
        Assert.notNull(name, "Property name must not be null");
        if (this.containsKey(name)) {
            return name;
        }
        String usName = name.replace('.', '_');
        if (!name.equals(usName) && this.containsKey(usName)) {
            return usName;
        }
        String ucName = name.toUpperCase();
        if (!name.equals(ucName)) {
            if (this.containsKey(ucName)) {
                return ucName;
            }
            String usUcName = ucName.replace('.', '_');
            if (!ucName.equals(usUcName) && this.containsKey(usUcName)) {
                return usUcName;
            }
        }
        return name;
    }

    private boolean containsKey(String name) {
        return this.isSecurityManagerPresent() ? ((Map)this.source).keySet().contains(name) : ((Map)this.source).containsKey(name);
    }

    protected boolean isSecurityManagerPresent() {
        return System.getSecurityManager() != null;
    }
}

