/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.lang.reflect.Constructor;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;

public class ThrowExceptionProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware,
CamelContextAware {
    private String id;
    private CamelContext camelContext;
    private Expression simple;
    private final Exception exception;
    private final Class<? extends Exception> type;
    private final String message;

    public ThrowExceptionProcessor(Exception exception) {
        this(exception, null, null);
    }

    public ThrowExceptionProcessor(Exception exception, Class<? extends Exception> type, String message) {
        this.exception = exception;
        this.type = type;
        this.message = message;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exception cause = this.exception;
        try {
            if (this.message != null && this.type != null) {
                String text = this.simple.evaluate(exchange, String.class);
                Constructor<? extends Exception> constructor = this.type.getDeclaredConstructor(String.class);
                cause = constructor.newInstance(text);
                exchange.setException(cause);
            } else {
                exchange.setException(cause);
            }
        }
        catch (Throwable e) {
            exchange.setException(new CamelExchangeException("Error creating new instance of " + this.exception.getClass(), exchange, e));
        }
        callback.done(true);
        return true;
    }

    @Override
    public String getTraceLabel() {
        return "throwException[" + this.exception.getClass().getSimpleName() + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Exception getException() {
        return this.exception;
    }

    public Class<? extends Exception> getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String toString() {
        return "ThrowException";
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "camelContext", this);
        if (this.message != null) {
            this.simple = this.camelContext.resolveLanguage("simple").createExpression(this.message);
        }
    }

    @Override
    protected void doStop() throws Exception {
    }
}

