/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.SessionAwareMessageListener;

public class EndpointMessageListener
implements SessionAwareMessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointMessageListener.class);
    private final JmsEndpoint endpoint;
    private final AsyncProcessor processor;
    private JmsBinding binding;
    private boolean eagerLoadingOfProperties;
    private Object replyToDestination;
    private JmsOperations template;
    private boolean disableReplyTo;
    private boolean async;

    public EndpointMessageListener(JmsEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = AsyncProcessorConverterHelper.convert(processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(javax.jms.Message message, Session session) throws JMSException {
        RuntimeCamelException rce;
        LOG.trace("onMessage START");
        LOG.debug("{} consumer received JMS message: {}", (Object)this.endpoint, (Object)message);
        try {
            boolean forceSync;
            String correlationId;
            Object replyDestination = this.getReplyToDestination(message);
            boolean sendReply = replyDestination != null && !this.disableReplyTo;
            Destination destination = JmsMessageHelper.getJMSDestination(message);
            if (destination != null && sendReply && !this.endpoint.isReplyToSameDestinationAllowed() && destination.equals(replyDestination)) {
                LOG.debug("JMSDestination and JMSReplyTo is the same, will skip sending a reply message to itself: {}", (Object)destination);
                sendReply = false;
            }
            Exchange exchange = this.createExchange(message, session, replyDestination);
            if (this.eagerLoadingOfProperties) {
                exchange.getIn().getHeaders();
            }
            if ((correlationId = message.getJMSCorrelationID()) != null) {
                LOG.debug("Received Message has JMSCorrelationID [{}]", (Object)correlationId);
            }
            LOG.trace("onMessage.process START");
            EndpointMessageListenerAsyncCallback callback = new EndpointMessageListenerAsyncCallback(message, exchange, this.endpoint, sendReply, replyDestination);
            boolean bl = forceSync = this.endpoint.isSynchronous() || this.endpoint.isTransacted();
            if (forceSync || !this.isAsync()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchange {} synchronously", (Object)exchange.getExchangeId());
                }
                try {
                    this.processor.process(exchange);
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
                finally {
                    callback.done(true);
                }
            } else {
                boolean sync;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchange {} asynchronously", (Object)exchange.getExchangeId());
                }
                if (!(sync = this.processor.process(exchange, callback))) {
                    return;
                }
            }
            rce = exchange.getException(RuntimeCamelException.class);
        }
        catch (Exception e) {
            rce = ObjectHelper.wrapRuntimeCamelException(e);
        }
        if (rce != null) {
            LOG.trace("onMessage END throwing exception: {}", (Object)rce.getMessage());
            throw rce;
        }
        LOG.trace("onMessage END");
    }

    public Exchange createExchange(javax.jms.Message message, Session session, Object replyDestination) {
        Exchange exchange = this.endpoint.createExchange();
        JmsBinding binding = this.getBinding();
        exchange.setProperty("CamelBinding", binding);
        exchange.setIn(new JmsMessage(message, session, binding));
        if (replyDestination != null && !this.disableReplyTo && !exchange.getPattern().isOutCapable()) {
            exchange.setPattern(ExchangePattern.InOut);
        }
        return exchange;
    }

    public JmsBinding getBinding() {
        if (this.binding == null) {
            this.binding = this.endpoint.getBinding();
        }
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    public boolean isEagerLoadingOfProperties() {
        return this.eagerLoadingOfProperties;
    }

    public void setEagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
        this.eagerLoadingOfProperties = eagerLoadingOfProperties;
    }

    public synchronized JmsOperations getTemplate() {
        if (this.template == null) {
            this.template = this.endpoint.createInOnlyTemplate();
        }
        return this.template;
    }

    public void setTemplate(JmsOperations template) {
        this.template = template;
    }

    public boolean isDisableReplyTo() {
        return this.disableReplyTo;
    }

    public void setDisableReplyTo(boolean disableReplyTo) {
        this.disableReplyTo = disableReplyTo;
    }

    public Object getReplyToDestination() {
        return this.replyToDestination;
    }

    public void setReplyToDestination(Object replyToDestination) {
        this.replyToDestination = replyToDestination;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    protected String determineCorrelationId(javax.jms.Message message) throws JMSException {
        String messageId = message.getJMSMessageID();
        String correlationId = message.getJMSCorrelationID();
        if (this.endpoint.getConfiguration().isUseMessageIDAsCorrelationID()) {
            return messageId;
        }
        if (ObjectHelper.isEmpty(correlationId)) {
            return messageId;
        }
        return correlationId;
    }

    protected void sendReply(Destination replyDestination, final javax.jms.Message message, final Exchange exchange, final Message out, final Exception cause) {
        if (replyDestination == null) {
            LOG.debug("Cannot send reply message as there is no replyDestination for: {}", (Object)out);
            return;
        }
        this.getTemplate().send(replyDestination, new MessageCreator(){

            @Override
            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message reply = EndpointMessageListener.this.endpoint.getBinding().makeJmsMessage(exchange, out, session, cause);
                String correlationID = EndpointMessageListener.this.determineCorrelationId(message);
                reply.setJMSCorrelationID(correlationID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} sending reply JMS message [correlationId:{}]: {}", EndpointMessageListener.this.endpoint, correlationID, reply);
                }
                return reply;
            }
        });
    }

    protected void sendReply(String replyDestination, final javax.jms.Message message, final Exchange exchange, final Message out, final Exception cause) {
        if (replyDestination == null) {
            LOG.debug("Cannot send reply message as there is no replyDestination for: {}", (Object)out);
            return;
        }
        this.getTemplate().send(replyDestination, new MessageCreator(){

            @Override
            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message reply = EndpointMessageListener.this.endpoint.getBinding().makeJmsMessage(exchange, out, session, cause);
                String correlationID = EndpointMessageListener.this.determineCorrelationId(message);
                reply.setJMSCorrelationID(correlationID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} sending reply JMS message [correlationId:{}]: {}", EndpointMessageListener.this.endpoint, correlationID, reply);
                }
                return reply;
            }
        });
    }

    protected Object getReplyToDestination(javax.jms.Message message) throws JMSException {
        Object destination = this.getReplyToDestination();
        if (destination == null) {
            destination = JmsMessageHelper.getJMSReplyTo(message);
        }
        return destination;
    }

    public String toString() {
        return "EndpointMessageListener[" + this.endpoint + "]";
    }

    private final class EndpointMessageListenerAsyncCallback
    implements AsyncCallback {
        private final javax.jms.Message message;
        private final Exchange exchange;
        private final JmsEndpoint endpoint;
        private final boolean sendReply;
        private final Object replyDestination;

        private EndpointMessageListenerAsyncCallback(javax.jms.Message message, Exchange exchange, JmsEndpoint endpoint, boolean sendReply, Object replyDestination) {
            this.message = message;
            this.exchange = exchange;
            this.endpoint = endpoint;
            this.sendReply = sendReply;
            this.replyDestination = replyDestination;
        }

        @Override
        public void done(boolean doneSync) {
            LOG.trace("onMessage.process END");
            Message body = null;
            Exception cause = null;
            RuntimeCamelException rce = null;
            if (this.exchange.isFailed() || this.exchange.isRollbackOnly()) {
                if (this.exchange.isRollbackOnly()) {
                    rce = ObjectHelper.wrapRuntimeCamelException(new RollbackExchangeException(this.exchange));
                } else if (this.exchange.getException() != null) {
                    if (this.endpoint.isTransferException()) {
                        body = null;
                        cause = this.exchange.getException();
                    } else {
                        rce = ObjectHelper.wrapRuntimeCamelException(this.exchange.getException());
                    }
                } else {
                    Message msg;
                    Message message = msg = this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn();
                    if (msg.isFault()) {
                        body = msg;
                        cause = null;
                    }
                }
            } else if (this.sendReply && this.exchange.getPattern().isOutCapable()) {
                body = this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn();
                cause = null;
            }
            if (rce == null && this.sendReply && (body != null || cause != null)) {
                LOG.trace("onMessage.sendReply START");
                if (this.replyDestination instanceof Destination) {
                    EndpointMessageListener.this.sendReply((Destination)this.replyDestination, this.message, this.exchange, body, cause);
                } else {
                    EndpointMessageListener.this.sendReply((String)this.replyDestination, this.message, this.exchange, body, cause);
                }
                LOG.trace("onMessage.sendReply END");
            }
            if (rce != null) {
                if (doneSync) {
                    this.exchange.setException(rce);
                } else if (this.endpoint.getErrorHandler() != null) {
                    this.endpoint.getErrorHandler().handleError(rce);
                }
            }
        }
    }
}

