/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.processor.LoggingErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingErrorHandlerBuilder
extends ErrorHandlerBuilderSupport {
    private Logger log = LoggerFactory.getLogger(Logger.class);
    private LoggingLevel level = LoggingLevel.ERROR;

    public LoggingErrorHandlerBuilder() {
    }

    public LoggingErrorHandlerBuilder(Logger log2) {
        this.log = log2;
    }

    public LoggingErrorHandlerBuilder(Logger log2, LoggingLevel level) {
        this.log = log2;
        this.level = level;
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public ErrorHandlerBuilder cloneBuilder() {
        LoggingErrorHandlerBuilder answer = new LoggingErrorHandlerBuilder();
        this.cloneBuilder(answer);
        return answer;
    }

    protected void cloneBuilder(LoggingErrorHandlerBuilder other) {
        super.cloneBuilder(other);
        other.level = this.level;
        other.log = this.log;
    }

    @Override
    public Processor createErrorHandler(RouteContext routeContext, Processor processor) {
        CamelLogger logger = new CamelLogger(this.log, this.level);
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.setLogExhausted(true);
        policy.setRetriesExhaustedLogLevel(this.level);
        policy.setLogStackTrace(true);
        policy.setLogRetryAttempted(false);
        policy.setRetryAttemptedLogLevel(LoggingLevel.OFF);
        policy.setLogRetryStackTrace(false);
        policy.setLogContinued(false);
        policy.setLogHandled(false);
        LoggingErrorHandler handler = new LoggingErrorHandler(routeContext.getCamelContext(), processor, logger, policy, this.getExceptionPolicyStrategy());
        this.configure(routeContext, handler);
        return handler;
    }

    public LoggingLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggingLevel level) {
        this.level = level;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log2) {
        this.log = log2;
    }

    public String getLogName() {
        return this.log != null ? this.log.getName() : null;
    }

    public void setLogName(String logName) {
        this.log = LoggerFactory.getLogger(logName);
    }

    public LoggingErrorHandlerBuilder level(LoggingLevel level) {
        this.level = level;
        return this;
    }

    public LoggingErrorHandlerBuilder log(Logger log2) {
        this.log = log2;
        return this;
    }

    public LoggingErrorHandlerBuilder logName(String logName) {
        this.setLogName(logName);
        return this;
    }
}

