/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.Date;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BooleanDataObject;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DateDataObject;
import org.activiti.bpmn.model.DoubleDataObject;
import org.activiti.bpmn.model.IntegerDataObject;
import org.activiti.bpmn.model.ItemDefinition;
import org.activiti.bpmn.model.LongDataObject;
import org.activiti.bpmn.model.StringDataObject;
import org.activiti.bpmn.model.ValuedDataObject;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ValuedDataObjectXMLConverter
extends BaseBpmnXMLConverter {
    protected boolean didWriteExtensionStartElement = false;

    public static String getXMLType() {
        return "dataObject";
    }

    public static Class<? extends BaseElement> getBpmnElementType() {
        return ValuedDataObject.class;
    }

    @Override
    protected String getXMLElementName() {
        return "dataObject";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr) throws Exception {
        StringDataObject dataObject = null;
        ItemDefinition itemSubjectRef = new ItemDefinition();
        String structureRef = xtr.getAttributeValue(null, "itemSubjectRef");
        String dataType = structureRef.substring(structureRef.indexOf(58) + 1);
        if (dataType.equals("string")) {
            dataObject = new StringDataObject();
        } else if (dataType.equals("int")) {
            dataObject = new IntegerDataObject();
        } else if (dataType.equals("long")) {
            dataObject = new LongDataObject();
        } else if (dataType.equals("double")) {
            dataObject = new DoubleDataObject();
        } else if (dataType.equals("boolean")) {
            dataObject = new BooleanDataObject();
        } else if (dataType.equals("datetime")) {
            dataObject = new DateDataObject();
        }
        if (dataObject != null) {
            dataObject.setId(xtr.getAttributeValue(null, "id"));
            dataObject.setName(xtr.getAttributeValue(null, "name"));
            BpmnXMLUtil.addXMLLocation((BaseElement)dataObject, xtr);
            itemSubjectRef.setStructureRef(structureRef);
            dataObject.setItemSubjectRef(itemSubjectRef);
            this.parseChildElements(xtr, (ValuedDataObject)dataObject);
        }
        return dataObject;
    }

    @Override
    public void convertToXML(XMLStreamWriter xtw, BaseElement baseElement, BpmnModel model) throws Exception {
        xtw.writeStartElement(this.getXMLElementName());
        this.didWriteExtensionStartElement = false;
        this.writeDefaultAttribute("id", baseElement.getId(), xtw);
        this.writeDefaultAttribute("name", ((ValuedDataObject)baseElement).getName(), xtw);
        this.writeDefaultAttribute("itemSubjectRef", ((ValuedDataObject)baseElement).getItemSubjectRef().getStructureRef(), xtw);
        this.writeExtensionChildElements(baseElement, xtw);
        xtw.writeEndElement();
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, XMLStreamWriter xtw) throws Exception {
    }

    @Override
    protected void writeExtensionChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
        ValuedDataObject dObj = (ValuedDataObject)element;
        if (StringUtils.isNotEmpty((CharSequence)dObj.getId())) {
            if (!this.didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                this.didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("activiti", "value", "http://activiti.org/bpmn");
            if (dObj.getValue() != null) {
                String value = null;
                if (dObj instanceof DateDataObject) {
                    DateTime dateTime = new DateTime((Object)((Date)dObj.getValue()));
                    value = ISODateTimeFormat.dateTimeNoMillis().print((ReadableInstant)dateTime);
                } else {
                    value = dObj.getValue().toString();
                }
                xtw.writeCharacters(value);
            }
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, XMLStreamWriter xtw) throws Exception {
    }

    private void parseChildElements(XMLStreamReader xtr, ValuedDataObject dataObject) throws Exception {
        boolean readyWithDataObject = false;
        try {
            while (!readyWithDataObject && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "value".equalsIgnoreCase(xtr.getLocalName())) {
                    String value = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                    if (dataObject instanceof DateDataObject) {
                        dataObject.setValue((Object)DateTime.parse((String)value, (DateTimeFormatter)ISODateTimeFormat.dateOptionalTimeParser()).toDate());
                        continue;
                    }
                    dataObject.setValue((Object)value);
                    continue;
                }
                if (!xtr.isEndElement() || !"dataObject".equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithDataObject = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing data object child elements", (Throwable)e);
        }
    }
}

